/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.v2.NugetGalleryFacet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

public abstract class NugetGalleryFacetSupport
extends FacetSupport
implements NugetGalleryFacet {
    public static final String WITH_NAMESPACES = " xmlns:d=\"http://schemas.microsoft.com/ado/2007/08/dataservices\" xmlns:m=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\" xmlns=\"http://www.w3.org/2005/Atom\"";
    public static final String NO_NAMESPACES = "";
    protected static final ObjectMapper mapper = new ObjectMapper();

    public boolean isRepoAuthoritative() {
        return this.getRepository().getType() instanceof HostedType;
    }

    protected int parseIntOrZero(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    protected NugetPackageCoords coords(Context context) {
        Map tokens = ((TokenMatcher.State)context.getAttributes().get(TokenMatcher.State.class)).getTokens();
        return new NugetPackageCoords((String)tokens.get("id"), (String)tokens.get("version"));
    }

    protected boolean isGroupRepository() {
        return this.getRepository().getType().getValue().equals("group");
    }

    protected List<Repository> getRepositories() {
        if (this.isGroupRepository()) {
            return ((GroupFacet)this.getRepository().facet(GroupFacet.class)).leafMembers();
        }
        return Collections.singletonList(this.getRepository());
    }

    protected List<String> groupByName() {
        return this.isGroupRepository() ? Collections.singletonList("name") : Collections.emptyList();
    }

    protected Map<String, Object> toData(NestedAttributesMap nugetAttributes, Map<String, String> extras) {
        HashMap data = Maps.newHashMap();
        data.putAll(nugetAttributes.backing());
        data.putAll(extras);
        return data;
    }
}

