/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.security;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.eclipse.sisu.Description;
import org.sonatype.nexus.security.UserPrincipalsHelper;
import org.sonatype.nexus.security.authc.NexusApiKeyAuthenticationToken;
import org.sonatype.nexus.security.authc.apikey.ApiKey;
import org.sonatype.nexus.security.authc.apikey.ApiKeyStore;
import org.sonatype.nexus.security.user.UserNotFoundException;

@Named(value="NuGetApiKey")
@Singleton
@Description(value="NuGet API-Key Realm")
public final class NugetApiKeyRealm
extends AuthenticatingRealm {
    @Inject
    private ApiKeyStore keyStore;
    @Inject
    private UserPrincipalsHelper principalsHelper;

    public String getName() {
        return "NuGetApiKey";
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof NexusApiKeyAuthenticationToken && "NuGetApiKey".equals(token.getPrincipal());
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) {
        PrincipalCollection principals = this.keyStore.getApiKeyByToken("NuGetApiKey", (char[])token.getCredentials()).map(ApiKey::getPrincipals).orElse(null);
        if (principals != null) {
            try {
                if (this.principalsHelper.getUserStatus(principals).isActive()) {
                    ((NexusApiKeyAuthenticationToken)token).setPrincipal(principals.getPrimaryPrincipal());
                    return new SimpleAuthenticationInfo(principals, token.getCredentials());
                }
            }
            catch (UserNotFoundException userNotFoundException) {
                this.keyStore.deleteApiKeys(principals);
            }
        }
        return null;
    }
}

