/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.search.sql;

import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.search.sql.SearchCustomFieldContributor;
import org.sonatype.nexus.repository.search.sql.SearchRecord;

@Named(value="nuget")
@Singleton
public class NugetSearchCustomFieldContributor
extends ComponentSupport
implements SearchCustomFieldContributor {
    public void populateSearchCustomFields(SearchRecord searchTableData, Asset asset) {
        this.log.debug("Populating search fields for {}", (Object)asset.path());
        Object formatAttributes = asset.attributes().get("nuget");
        Map attributes = formatAttributes instanceof Map ? (Map)formatAttributes : Collections.emptyMap();
        Optional componentOpt = asset.component();
        if (componentOpt.isPresent()) {
            Component component = (Component)componentOpt.get();
            searchTableData.addFormatFieldValue1(component.name());
            NugetPackageCoords nugetPackageCoords = new NugetPackageCoords(component.name(), component.version());
            searchTableData.addKeyword(nugetPackageCoords.toString());
        }
        if (!attributes.isEmpty()) {
            searchTableData.addFormatFieldValue2((String)attributes.get("tags"));
            searchTableData.addFormatFieldValue3((String)attributes.get("title"));
            searchTableData.addFormatFieldValue4((String)attributes.get("authors"));
            searchTableData.addFormatFieldValue5((String)attributes.get("description"));
            searchTableData.addFormatFieldValue6((String)attributes.get("summary"));
        }
    }
}

