/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.search.sql;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryContributionSupport;
import org.sonatype.nexus.repository.search.sql.query.syntax.StringTerm;
import org.sonatype.nexus.repository.search.sql.query.syntax.WildcardTerm;

@Named(value="attributes.nuget.authors")
@Singleton
public class NugetAuthorsSqlSearchQueryContribution
extends SqlSearchQueryContributionSupport {
    public static final String NAME = "attributes.nuget.authors";
    private static final String SPLIT_REGEX = "[^-,\\s\"]+|\"[^\"]+\"";
    private static final Pattern SPLITTER = Pattern.compile("[^-,\\s\"]+|\"[^\"]+\"");

    protected Stream<String> split(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Stream.empty();
        }
        Matcher matcher = SPLITTER.matcher(value);
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            matches.add(NugetAuthorsSqlSearchQueryContribution.maybeTrimQuotes((String)matcher.group()).replaceAll("(?<!\\\\)\\*", "\\\\*"));
        }
        return this.getValidTokens(matches).stream();
    }

    protected StringTerm createMatchTerm(boolean exact, String match) {
        return new WildcardTerm(match);
    }
}

