/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.rest;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.nuget.rest.NugetApiKeyXO;
import java.util.Base64;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.io.Charsets;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.subject.PrincipalCollection;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.wonderland.AuthTicketService;
import org.sonatype.nexus.rest.NotCacheable;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.security.authc.apikey.ApiKey;
import org.sonatype.nexus.security.authc.apikey.ApiKeyStore;
import org.sonatype.nexus.validation.Validate;

@Named
@Singleton
@Path(value="/internal/nuget-api-key")
@Produces(value={"application/json"})
public class NugetApiKeyResource
extends ComponentSupport
implements Resource {
    public static final String RESOURCE_URI = "/internal/nuget-api-key";
    private final Provider<ApiKeyStore> apiKeyStore;
    private final AuthTicketService authTicketService;
    private final SecurityHelper securityHelper;

    @Inject
    public NugetApiKeyResource(Provider<ApiKeyStore> apiKeyStore, AuthTicketService authTicketService, SecurityHelper securityHelper) {
        this.apiKeyStore = (Provider)Preconditions.checkNotNull(apiKeyStore);
        this.authTicketService = (AuthTicketService)Preconditions.checkNotNull((Object)authTicketService);
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
    }

    @GET
    @Timed
    @ExceptionMetered
    @RequiresPermissions(value={"nexus:apikey:read"})
    @Validate
    @NotCacheable
    public NugetApiKeyXO readKey(@NotNull @Valid @QueryParam(value="authToken") String base64AuthToken) {
        this.validateAuthToken(base64AuthToken);
        PrincipalCollection principals = this.securityHelper.subject().getPrincipals();
        char[] apiKey = ((ApiKeyStore)this.apiKeyStore.get()).getApiKey("NuGetApiKey", principals).map(ApiKey::getApiKey).orElseGet(() -> ((ApiKeyStore)this.apiKeyStore.get()).createApiKey("NuGetApiKey", principals));
        return new NugetApiKeyXO(apiKey);
    }

    @DELETE
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:apikey:delete"})
    @Validate
    public NugetApiKeyXO resetKey(@NotNull @Valid @QueryParam(value="authToken") String base64AuthToken) {
        this.validateAuthToken(base64AuthToken);
        PrincipalCollection principals = this.securityHelper.subject().getPrincipals();
        ((ApiKeyStore)this.apiKeyStore.get()).deleteApiKey("NuGetApiKey", principals);
        char[] apiKey = ((ApiKeyStore)this.apiKeyStore.get()).createApiKey("NuGetApiKey", principals);
        return new NugetApiKeyXO(apiKey);
    }

    private void validateAuthToken(String base64AuthToken) {
        String authToken = new String(Base64.getDecoder().decode(base64AuthToken), Charsets.UTF_8);
        this.log.debug("Validating authentication ticket: {}", (Object)authToken);
        if (!this.authTicketService.redeemTicket(authToken)) {
            throw new WebApplicationMessageException(Response.Status.FORBIDDEN, "Invalid authentication ticket");
        }
    }
}

