/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.view.Context;

public class NugetRepositoryBaseUrlSource {
    private final Optional<Repository> repository;

    public NugetRepositoryBaseUrlSource(@Nonnull Repository repository) {
        this.repository = Optional.of((Repository)Preconditions.checkNotNull((Object)repository));
    }

    public NugetRepositoryBaseUrlSource() {
        this.repository = Optional.empty();
    }

    public String get(@Nonnull Context context) {
        return this.repository.orElse(context.getRepository()).getUrl();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NugetRepositoryBaseUrlSource that = (NugetRepositoryBaseUrlSource)o;
        return Objects.equals(this.repository, that.repository);
    }

    public int hashCode() {
        return Objects.hash(this.repository);
    }
}

