/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.NugetPackagePathParser;
import java.util.ArrayList;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
@Named(value="nuget")
public class NugetPackagePathParserImpl
implements NugetPackagePathParser {
    private static final Splitter SPLITTER = Splitter.on((char)'/');

    @Override
    public NugetPackageCoords parsePath(String path) {
        ArrayList parts;
        Preconditions.checkNotNull((Object)path);
        String pathWithoutLeadingSlash = path;
        if (path.startsWith("/")) {
            pathWithoutLeadingSlash = path.substring(1);
        }
        if ((parts = Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)pathWithoutLeadingSlash))).size() == 2) {
            String id = (String)parts.get(0);
            String version = (String)parts.get(1);
            if (!id.isEmpty() && !version.isEmpty()) {
                return new NugetPackageCoords(id, version);
            }
        }
        return null;
    }
}

