/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.repository.nuget.NugetVersion;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryEvent;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.types.ProxyType;

@Named
@Facet.Exposed
public class NugetGroupVersionCheckFacetImpl
extends FacetSupport {
    private static final String PROXY_CONFIG_KEY = "proxy";
    private Set<NugetVersion> supportedVersions;

    public boolean versionSupported(NugetVersion requestVersion) {
        if (this.supportedVersions == null) {
            this.supportedVersions = this.calculateVersionsSupported();
        }
        return this.supportedVersions.contains((Object)requestVersion);
    }

    private Set<NugetVersion> calculateVersionsSupported() {
        GroupFacet groupFacet = (GroupFacet)this.getRepository().facet(GroupFacet.class);
        List repositories = groupFacet.allMembers();
        Set<NugetVersion> membersVersions = repositories.stream().filter(r -> r.getType() instanceof ProxyType).map(this::getNugetProxyVersion).collect(Collectors.toSet());
        switch (membersVersions.size()) {
            case 0: {
                return new HashSet<NugetVersion>(Arrays.asList(NugetVersion.V2, NugetVersion.V3));
            }
            case 1: {
                return membersVersions;
            }
        }
        return Collections.emptySet();
    }

    private NugetVersion getNugetProxyVersion(Repository repository) {
        String nugetVersionAttribute = (String)repository.getConfiguration().attributes("nugetProxy").get("nugetVersion", String.class, (Object)NugetVersion.V3.toString());
        return NugetVersion.valueOf(nugetVersionAttribute);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryEvent event) {
        Repository repository = event.getRepository();
        if (repository.getFormat().getValue().equals("nuget") && !(repository.getType() instanceof HostedType)) {
            this.supportedVersions = null;
        }
    }
}

