/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.repository.mime.ContentValidator;
import org.sonatype.nexus.repository.mime.DefaultContentValidator;

@Named(value="nuget")
@Singleton
public class NugetContentValidator
extends ComponentSupport
implements ContentValidator {
    private static final Set<String> NUGET_TRUSTED_TYPES = ImmutableSet.of((Object)"application/x-x509-ca-cert", (Object)"application/x-x509-user-cert", (Object)"application/octet-stream", (Object)"application/zip", (Object)"application/json", (Object)"application/xml", (Object[])new String[0]);
    private final DefaultContentValidator defaultContentValidator;

    @Inject
    public NugetContentValidator(DefaultContentValidator defaultContentValidator) {
        this.defaultContentValidator = (DefaultContentValidator)Preconditions.checkNotNull((Object)defaultContentValidator);
    }

    @Nonnull
    public String determineContentType(boolean strictContentTypeValidation, InputStreamSupplier contentSupplier, @Nullable MimeRulesSource mimeRulesSource, @Nullable String contentName, @Nullable String declaredContentType) throws IOException {
        if (declaredContentType != null && NUGET_TRUSTED_TYPES.contains(declaredContentType)) {
            return declaredContentType;
        }
        return this.defaultContentValidator.determineContentType(strictContentTypeValidation, contentSupplier, mimeRulesSource, contentName, declaredContentType);
    }
}

