/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal.v2;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.sonatype.nexus.repository.nuget.QueryCacheKey;
import com.sonatype.nexus.repository.nuget.datastore.NugetContentFacet;
import com.sonatype.nexus.repository.nuget.datastore.internal.v2.NugetV2FeedService;
import com.sonatype.nexus.repository.nuget.datastore.internal.v2.NugetV2LocalGalleryFacet;
import com.sonatype.nexus.repository.nuget.datastore.internal.v2.NugetV2ODataUtils;
import com.sonatype.nexus.repository.nuget.internal.CountReportingPolicy;
import com.sonatype.nexus.repository.nuget.internal.NugetFeedFetcher;
import com.sonatype.nexus.repository.nuget.internal.v2.FeedResult;
import com.sonatype.nexus.repository.nuget.v2.NugetV2CachingGalleryFacet;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.cache.expiry.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.NotNull;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.cache.CacheManager;
import org.sonatype.nexus.cache.NexusCache;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.content.event.component.ComponentDeletedEvent;
import org.sonatype.nexus.repository.httpclient.RemoteBlockedIOException;
import org.sonatype.nexus.repository.routing.RoutingRuleHelper;
import org.sonatype.nexus.repository.view.Payload;

@Named
@Facet.Exposed
public class NugetV2RemoteGalleryFacet
extends NugetV2LocalGalleryFacet
implements NugetV2CachingGalleryFacet {
    private static final String CONFIG_KEY = "nugetProxy";
    private final NugetFeedFetcher nugetFeedFetcher;
    private final RoutingRuleHelper routingRuleHelper;
    private final CacheManager<QueryCacheKey, Integer> cacheManager;
    private NexusCache<QueryCacheKey, Integer> cache;
    private Config config;

    @Inject
    public NugetV2RemoteGalleryFacet(@Named(value="${nexus.nuget.allow.multiple.latest:-true}") @Named(value="${nexus.nuget.allow.multiple.latest:-true}") boolean isLatestMultipleAllowed, NugetV2FeedService feedService, NugetFeedFetcher nugetFeedFetcher, CacheManager<QueryCacheKey, Integer> cacheManager, RoutingRuleHelper routingRuleHelper, Clock clock) {
        super(isLatestMultipleAllowed, feedService, clock);
        this.nugetFeedFetcher = Objects.requireNonNull(nugetFeedFetcher);
        this.cacheManager = Objects.requireNonNull(cacheManager);
        this.routingRuleHelper = Objects.requireNonNull(routingRuleHelper);
    }

    protected void doValidate(Configuration configuration) throws Exception {
        ((ConfigurationFacet)this.facet(ConfigurationFacet.class)).validateSection(configuration, CONFIG_KEY, Config.class, new Class[0]);
    }

    protected void doConfigure(Configuration configuration) throws Exception {
        this.config = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, CONFIG_KEY, Config.class);
        this.log.debug("Config: {}", (Object)this.config);
    }

    @Override
    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.maybeCreateCache();
    }

    protected void doUpdate(Configuration configuration) throws Exception {
        Config previous = this.config;
        super.doUpdate(configuration);
        if (!this.config.queryCacheItemMaxAge.equals(previous.queryCacheItemMaxAge)) {
            this.maybeDestroyCache();
            this.maybeCreateCache();
        }
    }

    protected void doDelete() throws Exception {
        this.maybeDestroyCache();
        this.config = null;
    }

    protected void doDestroy() throws Exception {
        this.config = null;
    }

    private void maybeCreateCache() {
        if (this.cache == null) {
            this.log.debug("Creating odata-query-cache for: {}", (Object)this.getRepository());
            this.cache = this.cacheManager.getCache(this.getCacheName(), QueryCacheKey.class, Integer.class, new Duration(TimeUnit.SECONDS, (long)this.config.queryCacheItemMaxAge.intValue()));
            this.log.debug("Created odata-query-cache: {}", this.cache);
        }
    }

    private void maybeDestroyCache() {
        if (this.cache != null) {
            this.log.debug("Destroying odata-query-cache for: {}", (Object)this.getRepository());
            this.cacheManager.destroyCache(this.getCacheName());
            this.cache = null;
        }
    }

    @Override
    public String getCacheName() {
        return String.valueOf(this.getRepository().getName()) + "#odata-query-cache";
    }

    @Subscribe
    @AllowConcurrentEvents
    @Guarded(by={"STARTED"})
    public void onComponentDeleted(ComponentDeletedEvent deleted) {
        Repository repository = deleted.getRepository().orElse(null);
        if (repository != null && this.matchesInvalidateCachesRepository(repository.getName())) {
            this.invalidateCaches();
        }
    }

    private boolean matchesInvalidateCachesRepository(String name) {
        return this.getRepositories().stream().anyMatch(repository -> repository.getName().equals(name) && !"hosted".equals(repository.getType().getValue()));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void invalidateCaches() {
        this.cache.removeAll();
    }

    @Override
    public Optional<String> entry(String repositoryBaseURL, String packageId, String packageVersion) {
        Optional<String> entry = super.entry(repositoryBaseURL, packageId, packageVersion);
        if (entry.isPresent()) {
            return entry;
        }
        String remoteQuery = NugetV2ODataUtils.buildPackagesRemoteQuery(packageId, packageVersion);
        URI callURI = NugetV2ODataUtils.buildQuery(remoteQuery, Collections.emptyMap());
        this.passQueryToRemoteRepos(callURI, this.getProxyRepositories(), new FeedLoaderCachePopulator());
        return super.entry(repositoryBaseURL, packageId, packageVersion);
    }

    private List<String> packageVersionsProxy(String packageId, Map<String, String> query) throws IOException {
        ArrayList<String> versions = new ArrayList<String>();
        String path = NugetV2ODataUtils.buildPackageVersionsRemoteQuery(packageId);
        URI callURI = NugetV2ODataUtils.buildQuery(path, query);
        for (Repository repository : this.getProxyRepositories()) {
            Payload payload;
            if (!this.isAllowed(repository, callURI.toString()) || (payload = this.nugetFeedFetcher.getRemotePayload(repository, callURI)) == null) continue;
            List<String> versionsRemote = NugetV2ODataUtils.deserializeListOfVersions(() -> payload.openInputStream());
            versions.addAll(versionsRemote);
        }
        return versions;
    }

    private List<String> packageVersionsHosted(String packageId, Map<String, String> query) {
        return this.doPackageVersions(this.getHostedRepositories(), packageId, query);
    }

    @Override
    public String packageVersions(String packageId, Map<String, String> query) {
        try {
            List<String> proxyVersions = this.packageVersionsProxy(packageId, query);
            List<String> hostedVersions = this.packageVersionsHosted(packageId, query);
            TreeSet<String> versions = new TreeSet<String>();
            versions.addAll(proxyVersions);
            versions.addAll(hostedVersions);
            return NugetV2ODataUtils.asJson(versions);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private int countProxy(String operation, Map<String, String> query) {
        List<Repository> proxyRepositories = this.getProxyRepositories();
        if (proxyRepositories.isEmpty()) {
            return 0;
        }
        URI uri = NugetV2ODataUtils.buildQuery(operation, query);
        List<Integer> remoteCounts = this.passQueryToRemoteRepos(uri, proxyRepositories, new CountFetcher());
        return NugetV2ODataUtils.sum(remoteCounts);
    }

    private int countHosted(Map<String, String> query) {
        List<Repository> hostedRepositories = this.getHostedRepositories();
        if (hostedRepositories.isEmpty()) {
            return 0;
        }
        return this.doCount(hostedRepositories, query);
    }

    @Override
    public int count(String operation, Map<String, String> query) {
        int countProxy = this.countProxy(operation, query);
        int countHosted = this.countHosted(query);
        return countProxy + countHosted;
    }

    @Override
    protected String doFeed(String repositoryBaseURL, String operation, Map<String, String> query) {
        Integer top = NugetV2ODataUtils.extractQueryParamAsInteger(query, "$top");
        Integer skip = NugetV2ODataUtils.extractQueryParamAsInteger(query, "$skip");
        Map<String, String> remoteQuery = NugetV2ODataUtils.modifyQueryForRemote(operation, query, top, skip);
        List<Integer> remoteCounts = this.passQueryToRemoteRepos(NugetV2ODataUtils.buildQuery(operation, remoteQuery), this.getProxyRepositories(), new FeedLoaderCachePopulator());
        FeedResult localResult = this.queryFeed(repositoryBaseURL, operation, query, this.getRepositories());
        int localCount = (Integer)MoreObjects.firstNonNull((Object)localResult.getCount(), (Object)0);
        int reportedCount = CountReportingPolicy.determineReportedCount(remoteCounts, localCount, top, skip);
        if ("Search".equals(operation)) {
            reportedCount = Integer.min(40, reportedCount);
        }
        localResult.setCount(reportedCount);
        return this.renderFeedResults(localResult);
    }

    private List<Integer> passQueryToRemoteRepos(URI path, Iterable<Repository> repositories, CachePopulator cachePopulator) {
        ArrayList<Integer> counts = new ArrayList<Integer>();
        for (Repository repo : repositories) {
            if (!this.isAllowed(repo, path.toString())) continue;
            try {
                QueryCacheKey key = new QueryCacheKey(repo.getName(), path);
                Optional<Integer> cachedCount = this.cache.get((Object)key);
                if (!cachedCount.isPresent()) {
                    cachedCount = Optional.of(cachePopulator.call(repo, path));
                    this.cache.put((Object)key, (Object)cachedCount.get());
                }
                counts.add((Integer)cachedCount.get());
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                this.log.warn("Exception attempting to contact proxied repository {}.", (Object)repo.getName(), (Object)e.getCause());
            }
            catch (RemoteBlockedIOException e) {
                this.log.trace("Failed to fetch from repository: {}", (Object)repo.getName(), (Object)e);
            }
            catch (IOException e) {
                this.log.trace("Failed to fetch, from repository: {}", (Object)repo.getName(), (Object)e);
            }
            catch (Exception e) {
                this.log.warn("Exception attempting to contact proxied repository {}.", (Object)repo.getName(), (Object)e);
            }
        }
        return counts;
    }

    protected List<Repository> getProxyRepositories() {
        return this.getRepositories().stream().filter(repository -> repository.getType().getValue().equals("proxy")).collect(Collectors.toList());
    }

    protected List<Repository> getHostedRepositories() {
        return this.getRepositories().stream().filter(repository -> repository.getType().getValue().equals("hosted")).collect(Collectors.toList());
    }

    private boolean isAllowed(Repository repository, String path) {
        return this.routingRuleHelper.isAllowed(repository, path);
    }

    private static interface CachePopulator {
        public Integer call(Repository var1, URI var2) throws Exception;
    }

    private static class Config {
        public static final int DEFAULT_QUERY_CACHE_ITEM_AGE = Time.minutes((long)60L).toSecondsI();
        @NotNull
        public Integer queryCacheItemMaxAge = DEFAULT_QUERY_CACHE_ITEM_AGE;

        private Config() {
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "queryCacheItemMaxAge=" + this.queryCacheItemMaxAge + '}';
        }
    }

    private class CountFetcher
    implements CachePopulator {
        private CountFetcher() {
        }

        @Override
        public Integer call(Repository remote, URI nugetQuery) throws Exception {
            Integer result = NugetV2RemoteGalleryFacet.this.nugetFeedFetcher.getCount(remote, nugetQuery);
            if (result == null) {
                return 0;
            }
            return result;
        }
    }

    private class FeedLoaderCachePopulator
    implements CachePopulator {
        private FeedLoaderCachePopulator() {
        }

        @Override
        public Integer call(Repository repository, URI uri) throws IOException {
            NugetFeedFetcher.FeedFetcherResult feeds = NugetV2RemoteGalleryFacet.this.nugetFeedFetcher.getFeeds(repository, uri, false);
            List<Map<String, String>> metadataFiles = feeds.getMetadataFiles();
            ((NugetContentFacet)repository.facet(NugetContentFacet.class)).putV2Metadata(metadataFiles);
            Integer count = feeds.getCount();
            if (count == null) {
                return 0;
            }
            return count;
        }
    }
}

