/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal.v2;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.datastore.NugetContentFacet;
import com.sonatype.nexus.repository.nuget.datastore.internal.NugetProxyDispatcherFacet;
import com.sonatype.nexus.repository.nuget.datastore.internal.v2.NugetV2ODataUtils;
import com.sonatype.nexus.repository.nuget.internal.NugetFeedFetcher;
import com.sonatype.nexus.repository.nuget.internal.NugetHandlerUtils;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named
@Facet.Exposed
public class NugetV2ProxyFacet
extends FacetSupport {
    private final NugetFeedFetcher feedFetcher;

    @Inject
    public NugetV2ProxyFacet(NugetFeedFetcher feedFetcher) {
        this.feedFetcher = (NugetFeedFetcher)((Object)Preconditions.checkNotNull((Object)((Object)feedFetcher)));
    }

    @Nullable
    public Content getCachedContent(Context context) {
        NugetPackageCoords coords = NugetHandlerUtils.getPackageCoordinates(context);
        return ((NugetContentFacet)this.facet(NugetContentFacet.class)).findAsset(coords.getId(), coords.getVersion()).filter(it -> it.blob().isPresent()).map(it -> it.download()).orElse(null);
    }

    public Content store(Context context, Content content) {
        NugetPackageCoords coords = NugetHandlerUtils.getPackageCoordinates(context);
        return this.storePackage(coords, content);
    }

    public Content storePackage(NugetPackageCoords coords, Content content) {
        Optional<FluentComponent> fluentComponentOptional = ((NugetContentFacet)this.facet(NugetContentFacet.class)).findComponent(coords.getId(), coords.getVersion());
        FluentAsset asset = fluentComponentOptional.flatMap(it -> it.assets().stream().findFirst()).orElse(null);
        Preconditions.checkState((fluentComponentOptional.isPresent() && asset != null ? 1 : 0) != 0, (Object)"Component metadata does not exist yet");
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = ((ContentFacet)this.facet(ContentFacet.class)).blobs().ingest((Payload)content, NugetPackageUtils.HASH_ALGORITHMS);){
            return asset.attach(tempBlob).markAsCached((Payload)content).download();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void indicateVerified(Context context, Content content, CacheInfo cacheInfo) throws IOException {
        Preconditions.checkNotNull((Object)cacheInfo);
        NugetPackageCoords coords = NugetHandlerUtils.getPackageCoordinates(context);
        Optional<FluentAsset> fluentAsset = ((NugetContentFacet)this.facet(NugetContentFacet.class)).findAsset(coords.getId(), coords.getVersion());
        if (!fluentAsset.isPresent()) {
            this.log.debug("Attempting to set cache info for non-existent nuget asset: {} on repository: {}", (Object)coords, (Object)this.getRepository().getName());
            return;
        }
        FluentAsset asset = fluentAsset.get();
        this.log.debug("Updating cacheInfo for asset: {} on repository: {} to {}", new Object[]{asset.path(), this.getRepository().getName(), cacheInfo});
        asset.markAsCached(cacheInfo);
    }

    @Nullable
    public String getUrl(Context context) {
        return context.getRequest().getPath().substring(1);
    }

    public Content fetch(Context context, Content stale) throws IOException {
        NugetPackageCoords coords = NugetHandlerUtils.getPackageCoordinates(context);
        String remoteQuerySuffix = NugetV2ODataUtils.buildPackagesRemoteQuery(coords.getId(), coords.getVersion());
        URI remoteEntryUri = ((ProxyFacet)this.facet(ProxyFacet.class)).getRemoteUrl().resolve(remoteQuerySuffix);
        StringBuilder contentLocation = new StringBuilder();
        this.feedFetcher.cachePackageFeed(this.getRepository(), remoteEntryUri, false, data -> {
            if (contentLocation.length() == 0) {
                contentLocation.append((String)data.get("LOCATION"));
            }
            ((NugetContentFacet)this.facet(NugetContentFacet.class)).putV2Metadata(Collections.singletonList(data));
        });
        if (contentLocation.length() == 0) {
            this.log.debug("Proxy repo {} found no package entry for {} {} at remote", new Object[]{this.getRepository().getName(), coords.getId(), coords.getVersion()});
            return null;
        }
        return ((NugetProxyDispatcherFacet)this.facet(NugetProxyDispatcherFacet.class)).fetch(contentLocation.toString(), context, stale);
    }
}

