/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal.v2;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.sonatype.nexus.repository.nuget.internal.NugetDataUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.odata4j.producer.QueryInfo;
import org.odata4j.producer.resources.OptionsQueryParser;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.view.Parameters;

public class NugetV2ODataUtils {
    private static final int TWO_PAGES = 80;
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String FILTER_QUERY_VALUE = "tolower(Id) eq ";
    private static final String FILTER = "$filter";

    public static Map<String, String> applyQueryDefaults(Map<String, String> originalQuery) {
        CaseInsensitiveMap query = new CaseInsensitiveMap(originalQuery);
        if (query.containsKey(FILTER)) {
            String filter = (String)query.get(FILTER);
            query.put(FILTER, NugetV2ODataUtils.applyQueryDefaultsToFilterParam(filter));
        }
        return query;
    }

    private static String applyQueryDefaultsToFilterParam(String filter) {
        if (StringUtils.isEmpty((String)filter)) {
            return filter;
        }
        return filter.replaceAll("(?i)IsLatestVersion eq True", "IsLatestVersion").replaceAll("(?i)IsAbsoluteLatestVersion eq True", "IsAbsoluteLatestVersion").replaceAll("(?i)(IsLatestVersion|IsAbsoluteLatestVersion)", "($1 eq true)");
    }

    public static Optional<Integer> getSkip(Map<String, String> query) {
        String skip = query.get("$skip");
        if (skip == null) {
            return Optional.empty();
        }
        return Optional.of(Integer.parseInt(skip));
    }

    public static Optional<String> getPackageId(Map<String, String> query) {
        String packageId = query.get("id");
        if (packageId == null && query.get(FILTER) == null) {
            return Optional.empty();
        }
        if (query.get(FILTER) != null) {
            return NugetV2ODataUtils.getPackageIdFromQueryFilter(query);
        }
        return Optional.ofNullable(StringUtils.strip((String)packageId, (String)"\" '"));
    }

    private static Optional<String> getPackageIdFromQueryFilter(Map<String, String> query) {
        String filter = query.get(FILTER);
        return Optional.ofNullable(StringUtils.substringBetween((String)filter, (String)"tolower(Id) eq '", (String)"'"));
    }

    private static QueryInfo parseQuery(Map<String, String> query) {
        try {
            return new QueryInfo(null, OptionsQueryParser.parseTop((String)query.get("$top")), OptionsQueryParser.parseSkip((String)query.get("$skip")), OptionsQueryParser.parseFilter((String)query.get(FILTER)), OptionsQueryParser.parseOrderBy((String)query.get("$orderby")), OptionsQueryParser.parseSkipToken((String)query.get("$skiptoken")), null, null, null);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Bad Request - Error in query syntax.", e);
        }
    }

    public static int getPageSize(Map<String, String> query) {
        return NugetV2ODataUtils.getPageSize(NugetV2ODataUtils.parseQuery(query));
    }

    private static int getPageSize(QueryInfo odata) {
        int pageSize = 40;
        if (odata.top != null && odata.top < pageSize) {
            pageSize = odata.top;
        }
        return pageSize;
    }

    public static Optional<Boolean> extractBooleanValue(Map<String, ?> source, String key) {
        Object value = source.get(key);
        if (value instanceof Boolean) {
            return Optional.of((Boolean)value);
        }
        if (value instanceof String) {
            return Optional.of(Boolean.parseBoolean((String)value));
        }
        return Optional.empty();
    }

    public static Boolean extractIsLatestVersionQueryParam(Map<String, String> query) {
        return query.containsValue("(IsLatestVersion eq true)");
    }

    public static Boolean extractIsAbsoluteLatestVersionQueryParam(Map<String, String> query) {
        return query.containsValue("(IsAbsoluteLatestVersion eq true)");
    }

    public static List<String> extractSearchTerms(Map<String, String> query) {
        String searchTermParam = query.getOrDefault("searchTerm", "");
        return Arrays.stream(StringUtils.strip((String)searchTermParam, (String)"\" '").split("[+\\s]+")).map(searchTerm -> searchTerm.toLowerCase()).filter(searchTerm -> StringUtils.isNotBlank((String)searchTerm)).collect(Collectors.toList());
    }

    public static void updateDerivedTextFields(Map<String, Object> assetFormatAttributes) {
        Joiner joiner = Joiner.on((String)" ").skipNulls();
        String keywords = joiner.join(assetFormatAttributes.get("id"), assetFormatAttributes.get("title"), new Object[]{assetFormatAttributes.get("description"), assetFormatAttributes.get("tags"), assetFormatAttributes.get("authors")});
        assetFormatAttributes.put("keywords", keywords.toLowerCase());
    }

    public static Map<String, Object> extractAssetFormatAttributes(Map<String, String> metadata) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("authors", metadata.get("AUTHORS"));
        attributes.put("copyright", metadata.get("COPYRIGHT"));
        attributes.put("dependencies", metadata.get("DEPENDENCIES"));
        attributes.put("description", metadata.get("DESCRIPTION"));
        attributes.put("gallery_details_url", metadata.get("GALLERYDETAILSURL"));
        attributes.put("icon_url", metadata.get("ICONURL"));
        attributes.put("id", metadata.get("ID"));
        attributes.put("is_prerelease", NugetDataUtils.isPrerelease(metadata));
        attributes.put("language", metadata.get("LANGUAGE"));
        attributes.put("license", metadata.get("LICENSE"));
        attributes.put("license_type", metadata.get("LICENSETYPE"));
        attributes.put("license_url", metadata.get("LICENSEURL"));
        attributes.put("location", metadata.get("LOCATION"));
        attributes.put("package_hash", metadata.get("PACKAGEHASH"));
        attributes.put("package_hash_algorithm", metadata.get("PACKAGEHASHALGORITHM"));
        attributes.put("package_size", Long.parseLong(metadata.get("PACKAGESIZE")));
        attributes.put("project_url", metadata.get("PROJECTURL"));
        attributes.put("release_notes", metadata.get("RELEASENOTES"));
        attributes.put("report_abuse_url", metadata.get("REPORTABUSEURL"));
        attributes.put("require_license_acceptance", Boolean.parseBoolean(metadata.get("REQUIRELICENSEACCEPTANCE")));
        attributes.put("summary", metadata.get("SUMMARY"));
        attributes.put("tags", metadata.get("TAGS"));
        attributes.put("title", metadata.get("TITLE"));
        attributes.put("version", NugetDataUtils.normalizeVersion(metadata));
        attributes.put("min_client_version", metadata.get("MINCLIENTVERSION"));
        return attributes;
    }

    public static Map<String, String> extractComponentFormatAttributes(Map<String, String> metadata) {
        String id = Objects.requireNonNull(metadata.get("ID"));
        String version = NugetDataUtils.checkVersion(NugetDataUtils.normalizeVersion(metadata));
        HashMap<String, String> formatAttributes = new HashMap<String, String>();
        formatAttributes.put("id", id);
        formatAttributes.put("package_hash", metadata.get("PACKAGEHASH"));
        formatAttributes.put("package_hash_algorithm", metadata.get("PACKAGEHASHALGORITHM"));
        formatAttributes.put("title", metadata.get("TITLE"));
        formatAttributes.put("version", version);
        return formatAttributes;
    }

    public static int parseIntOrZero(@Nullable String value) {
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static Map<String, Object> concat(Map<String, ?> ... map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, ?>[] mapArray = map;
        int n = map.length;
        int n2 = 0;
        while (n2 < n) {
            Map<String, ?> it = mapArray[n2];
            result.putAll(it);
            ++n2;
        }
        return result;
    }

    @Nullable
    public static Integer extractQueryParamAsInteger(Map<String, String> query, String queryParamName) {
        String value = query.get(queryParamName);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Map<String, String> asMap(Parameters parameters) {
        HashMap<String, String> query = new HashMap<String, String>();
        for (String param : parameters.names()) {
            query.put(param, parameters.get(param));
        }
        return query;
    }

    public static Map<String, String> modifyQueryForRemote(String operation, Map<String, String> query, Integer top, Integer skip) {
        HashMap<String, String> remoteQuery = new HashMap<String, String>(query);
        if ("Search".equals(operation) && top != null && skip != null) {
            remoteQuery.put("$top", "80");
            remoteQuery.put("$skip", "0");
        } else if (top == null || top > 80) {
            remoteQuery.put("$top", "80");
        }
        return remoteQuery;
    }

    public static String buildPackagesRemoteQuery(String packageId, String packageVersion) {
        return "Packages(Id='" + packageId + "',Version='" + packageVersion + "')";
    }

    public static String buildPackageVersionsRemoteQuery(String packageId) {
        return "package-versions/" + packageId;
    }

    public static URI buildQuery(String path, Map<String, String> queryParams) {
        URIBuilder uri = new URIBuilder();
        uri.setPath(path);
        if (!queryParams.isEmpty()) {
            ArrayList paramClauses = Lists.newArrayList();
            for (Map.Entry<String, String> param : queryParams.entrySet()) {
                paramClauses.add(String.valueOf(param.getKey()) + "=" + param.getValue());
            }
            uri.setCustomQuery(Joiner.on((char)'&').join((Iterable)paramClauses));
        }
        try {
            return uri.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static String asJson(Collection<String> collection) {
        try {
            return mapper.writeValueAsString(collection);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> deserializeListOfVersions(InputStreamSupplier src) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream inputStream = src.get();){
                return (List)mapper.readValue(inputStream, (TypeReference)new TypeReference<List<String>>(){});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static int sum(Iterable<Integer> values) {
        int total = 0;
        for (Integer i : values) {
            total += Objects.requireNonNull(i).intValue();
        }
        return total;
    }
}

