/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal.v2;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.xml.XmlEscapers;
import com.sonatype.nexus.repository.nuget.datastore.NugetContentFacet;
import com.sonatype.nexus.repository.nuget.datastore.internal.v2.NugetV2FeedService;
import com.sonatype.nexus.repository.nuget.datastore.internal.v2.NugetV2GalleryFacet;
import com.sonatype.nexus.repository.nuget.datastore.internal.v2.NugetV2ODataUtils;
import com.sonatype.nexus.repository.nuget.internal.v2.FeedResult;
import com.sonatype.nexus.repository.nuget.odata.ODataFeedUtils;
import com.sonatype.nexus.repository.nuget.odata.ODataTemplates;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.common.io.Cooperation;
import org.sonatype.nexus.common.io.CooperationFactory;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.utils.FormatAttributesUtils;
import org.sonatype.nexus.repository.group.GroupFacet;

@Named
public class NugetV2LocalGalleryFacet
extends FacetSupport
implements NugetV2GalleryFacet {
    private static final String WITH_NAMESPACES = " xmlns:d=\"http://schemas.microsoft.com/ado/2007/08/dataservices\" xmlns:m=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\" xmlns=\"http://www.w3.org/2005/Atom\"";
    private final boolean isLatestMultipleAllowed;
    private final NugetV2FeedService feedService;
    @VisibleForTesting
    protected Clock clock;
    @Nullable
    private CooperationFactory.Builder cooperationBuilder;
    @Nullable
    private Cooperation feedCooperation;

    @Inject
    protected NugetV2LocalGalleryFacet(@Named(value="${nexus.nuget.allow.multiple.latest:-true}") @Named(value="${nexus.nuget.allow.multiple.latest:-true}") boolean isLatestMultipleAllowed, NugetV2FeedService feedService, Clock clock) {
        this.isLatestMultipleAllowed = isLatestMultipleAllowed;
        this.feedService = Objects.requireNonNull(feedService);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
    }

    @Inject
    protected void configureCooperation(CooperationFactory cooperationFactory, @Named(value="${nexus.nuget.cooperation.enabled:-true}") @Named(value="${nexus.nuget.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.nuget.cooperation.majorTimeout:-0s}") @Named(value="${nexus.nuget.cooperation.majorTimeout:-0s}") Time majorTimeout, @Named(value="${nexus.nuget.cooperation.minorTimeout:-30s}") @Named(value="${nexus.nuget.cooperation.minorTimeout:-30s}") Time minorTimeout, @Named(value="${nexus.nuget.cooperation.threadsPerKey:-100}") @Named(value="${nexus.nuget.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        if (cooperationEnabled) {
            this.cooperationBuilder = cooperationFactory.configure().majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey);
        }
    }

    @VisibleForTesting
    protected void buildCooperation() {
        if (this.cooperationBuilder != null) {
            String repositoryName = this.getRepository().getName();
            this.feedCooperation = this.cooperationBuilder.build(String.valueOf(repositoryName) + ":nuget_feed");
            this.log.info("Enabled NuGet feed cooperation for {}", (Object)repositoryName);
        }
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.buildCooperation();
    }

    @Override
    public Optional<String> entry(String repositoryBaseURL, String packageId, String packageVersion) {
        return this.queryEntry(repositoryBaseURL, packageId, packageVersion).map(entryData -> ODataTemplates.interpolate(ODataTemplates.NUGET_ENTRY, entryData));
    }

    @Override
    public String feed(String repositoryBaseURL, String operation, Map<String, String> query) {
        if (this.feedCooperation == null) {
            return this.doFeed(repositoryBaseURL, operation, query);
        }
        String feedKey = String.valueOf(repositoryBaseURL) + ':' + operation + ':' + query;
        try {
            return (String)this.feedCooperation.cooperate(feedKey, __ -> this.doFeed(repositoryBaseURL, operation, query));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String packageVersions(String packageId, Map<String, String> query) {
        List<Repository> repositories = this.getRepositories();
        List<String> versions = this.doPackageVersions(repositories, packageId, query);
        return NugetV2ODataUtils.asJson(versions);
    }

    protected List<String> doPackageVersions(Iterable<Repository> repositories, String packageId, Map<String, String> query) {
        return this.feedService.packageVersionsQuery(repositories, packageId, query);
    }

    @Override
    public int count(String operation, Map<String, String> query) {
        return this.doCount(this.getRepositories(), query);
    }

    protected int doCount(Iterable<Repository> repositories, Map<String, String> query) {
        long count = this.feedService.feedCount(query, repositories);
        return Long.valueOf(count).intValue();
    }

    protected String doFeed(String repositoryBaseURL, String operation, Map<String, String> query) {
        this.log.debug("Select: {}", query);
        List<Repository> repositories = this.getRepositories();
        FeedResult result = this.queryFeed(repositoryBaseURL, operation, query, repositories);
        return this.renderFeedResults(result);
    }

    protected FeedResult queryFeed(String repositoryBaseURL, String operation, Map<String, String> query, Iterable<Repository> repositories) {
        FeedResult result = new FeedResult(repositoryBaseURL, operation, query);
        this.inlineCountRequested(result, query, repositories);
        List<Asset> assets = this.feedService.feedQuery(query, repositories);
        int n = 0;
        for (Asset asset : assets) {
            ++n;
            Map formatAttributes = FormatAttributesUtils.getFormatAttributes((Asset)asset, (String)"nuget");
            Map<String, String> extraTemplateVars = this.extraTemplateVars(repositoryBaseURL, operation);
            Map<String, Object> data = NugetV2ODataUtils.concat(formatAttributes, extraTemplateVars);
            if (this.isLatestMultipleAllowed) {
                result.addEntryAsLatest(data);
            } else {
                result.addEntry(data);
            }
            if (n != 40) continue;
            result.setSkipLinkEntry(data);
        }
        return result;
    }

    private void inlineCountRequested(FeedResult result, Map<String, String> query, Iterable<Repository> repositories) {
    }

    protected boolean isGroupRepository() {
        return this.getRepository().getType().getValue().equals("group");
    }

    protected List<Repository> getRepositories() {
        if (this.isGroupRepository()) {
            return ((GroupFacet)this.getRepository().facet(GroupFacet.class)).leafMembers();
        }
        return Collections.singletonList(this.getRepository());
    }

    protected String renderFeedResults(FeedResult result) {
        StringBuilder xml = new StringBuilder();
        xml.append(ODataTemplates.interpolate(ODataTemplates.NUGET_FEED, this.extraTemplateVars(result.getBase(), result.getOperation())));
        if (result.getCount() != null) {
            xml.append(ODataTemplates.interpolate(ODataTemplates.NUGET_INLINECOUNT, Collections.singletonMap("COUNT", String.valueOf(result.getCount()))));
        }
        List<Map<String, ?>> entries = this.isLatestMultipleAllowed ? result.getEntriesAsLatest() : result.getEntries();
        for (Map<String, ?> data : entries) {
            xml.append(ODataTemplates.interpolate(ODataTemplates.NUGET_ENTRY, data));
        }
        if (result.getSkipLinkEntry() != null) {
            String skipLink = this.odataLink(result.getBase(), result.getOperation(), ODataFeedUtils.skipLinkQueryString(result.getQuery()));
            xml.append("  <link rel=\"next\" href=\"").append(XmlEscapers.xmlAttributeEscaper().escape(skipLink)).append("\"/>\n");
        }
        return xml.append("</feed>").toString();
    }

    private String odataLink(String base, String operation, String queryString) {
        return String.format("%s/%s()?%s", base, operation, queryString);
    }

    private Map<String, String> extraTemplateVars(String base, String operation) {
        return ImmutableMap.of((Object)"BASEURI", (Object)base, (Object)"ENDPOINT", (Object)operation, (Object)"LASTUPDATED", (Object)ODataFeedUtils.datetime(this.clock.millis()), (Object)"NAMESPACES", (Object)"");
    }

    private Optional<Map<String, Object>> queryEntry(String repositoryBaseURL, String packageId, String packageVersion) {
        FluentAsset fluentAsset = ((NugetContentFacet)this.facet(NugetContentFacet.class)).findAsset(packageId, packageVersion).orElse(null);
        if (fluentAsset == null) {
            return Optional.empty();
        }
        Map formatAttributes = FormatAttributesUtils.getFormatAttributes((FluentAsset)fluentAsset);
        Map<String, String> mapRepositoryBaseURL = this.buildMapRepositoryBaseURL(repositoryBaseURL);
        Map<String, Object> concat = NugetV2ODataUtils.concat(formatAttributes, mapRepositoryBaseURL);
        return Optional.of(concat);
    }

    private Map<String, String> buildMapRepositoryBaseURL(String repositoryBaseURL) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("BASEURI", repositoryBaseURL);
        result.put("NAMESPACES", WITH_NAMESPACES);
        return result;
    }
}

