/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal.v2;

import com.sonatype.nexus.repository.nuget.datastore.NugetContentFacet;
import com.sonatype.nexus.repository.nuget.datastore.internal.v2.NugetV2ODataUtils;
import com.sonatype.nexus.repository.nuget.internal.NugetProperties;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.utils.FormatAttributesUtils;

@Named
@Singleton
public class NugetV2FeedService {
    public List<String> packageVersionsQuery(Iterable<Repository> repositories, String packageId, Map<String, String> query) {
        Stream<Asset> assets = this.getAssets(repositories, Optional.of(packageId));
        assets = this.applyPrereleaseFilter(assets, query);
        return assets.map(asset -> {
            Map formatAttributes = FormatAttributesUtils.getFormatAttributes((Asset)asset, (String)"nuget");
            return (String)formatAttributes.get("version");
        }).collect(Collectors.toList());
    }

    public long feedCount(Map<String, String> query, Iterable<Repository> repositories) {
        return this.streamFeedQuery(query, repositories).count();
    }

    public List<Asset> feedQuery(Map<String, String> query, Iterable<Repository> repositories) {
        Stream<Asset> assets = this.streamFeedQuery(query, repositories);
        return assets.collect(Collectors.toList());
    }

    private Stream<Asset> applyLimits(Stream<Asset> assets, Map<String, String> query) {
        int limit = NugetV2ODataUtils.getPageSize(query);
        int skip = NugetV2ODataUtils.getSkip(query).orElse(0);
        return assets.skip(skip).limit(limit);
    }

    private Stream<Asset> applyDistinct(Stream<Asset> assets) {
        ConcurrentHashMap.KeySetView uniqueAssetPaths = ConcurrentHashMap.newKeySet();
        return assets.filter(asset -> {
            String path = asset.path();
            if (uniqueAssetPaths.contains(path)) {
                return false;
            }
            uniqueAssetPaths.add(path);
            return true;
        });
    }

    private Stream<Asset> streamFeedQuery(Map<String, String> originalQuery, Iterable<Repository> repositories) {
        Map<String, String> query = NugetV2ODataUtils.applyQueryDefaults(originalQuery);
        Optional<String> packageId = NugetV2ODataUtils.getPackageId(query);
        Stream<Asset> assets = this.getAssets(repositories, packageId);
        assets = this.applySearchTermsFilter(assets, query);
        assets = this.applyIsLatestVersionFilter(assets, query);
        assets = this.applyIsAbsoluteLatestVersionFilter(assets, query);
        assets = this.applyPrereleaseFilter(assets, query);
        assets = this.applyDistinct(assets);
        assets = this.applyOrdering(assets, query);
        return this.applyLimits(assets, query);
    }

    private Stream<Asset> getAssets(Iterable<Repository> repositories, Optional<String> packageId) {
        Stream<NugetContentFacet> facets = StreamSupport.stream(repositories.spliterator(), false).map(repository -> (NugetContentFacet)repository.facet(NugetContentFacet.class));
        if (packageId.isPresent()) {
            return facets.flatMap(facet -> StreamSupport.stream(facet.findAssetsByComponentName((String)packageId.get()).spliterator(), false));
        }
        return facets.flatMap(facet -> StreamSupport.stream(facet.findAssets().spliterator(), false));
    }

    private Stream<Asset> applyOrdering(Stream<Asset> assets, Map<String, String> query) {
        String orderBy = query.get("$orderby");
        if (orderBy != null) {
            return this.sortWithOrderBy(assets, orderBy);
        }
        return this.defaultSort(assets);
    }

    private Stream<Asset> defaultSort(Stream<Asset> assets) {
        return assets.sorted(Comparator.comparing(asset -> {
            Map formatAttributes = FormatAttributesUtils.getFormatAttributes((Asset)((Asset)asset), (String)"nuget");
            Object downloadCount = formatAttributes.get("download_count");
            if (downloadCount == null) {
                return 0;
            }
            return (Integer)downloadCount;
        }).reversed());
    }

    private Stream<Asset> sortWithOrderBy(Stream<Asset> assets, String orderBy) {
        String[] paramsAndOrders = orderBy.split(",");
        Comparator<Object> comparator = null;
        String[] stringArray = paramsAndOrders;
        int n = paramsAndOrders.length;
        int n2 = 0;
        while (n2 < n) {
            String paramAndOrder = stringArray[n2];
            String[] paramAndOrderArr = paramAndOrder.split(" ");
            String param = paramAndOrderArr[0];
            comparator = comparator == null ? Comparator.comparing(asset -> this.comparingKey(asset, param)) : comparator.thenComparing(asset -> this.comparingKey(asset, param));
            if (paramAndOrderArr.length > 1 && paramAndOrderArr[1].equalsIgnoreCase("desc")) {
                comparator = comparator.reversed();
            }
            ++n2;
        }
        if (comparator == null) {
            return assets;
        }
        return assets.sorted(comparator);
    }

    private String comparingKey(Object asset, String param) {
        Map formatAttributes = FormatAttributesUtils.getFormatAttributes((Asset)((Asset)asset), (String)"nuget");
        Object attribute = formatAttributes.get(NugetProperties.ATTRIB_NAMES.get(param.toUpperCase()));
        if (attribute == null) {
            return "";
        }
        return attribute.toString().toLowerCase();
    }

    private Stream<Asset> applyPrereleaseFilter(Stream<Asset> assets, Map<String, String> query) {
        String prerelease = query.get("includePrerelease");
        if (prerelease != null && !Boolean.parseBoolean(prerelease)) {
            return assets.filter(asset -> {
                Map formatAttributes = FormatAttributesUtils.getFormatAttributes((Asset)asset, (String)"nuget");
                Optional<Boolean> value = NugetV2ODataUtils.extractBooleanValue(formatAttributes, "is_prerelease");
                return value.isPresent() && value.get() == false;
            });
        }
        return assets;
    }

    private Stream<Asset> applyIsLatestVersionFilter(Stream<Asset> assets, Map<String, String> query) {
        Boolean isLatestVersionQueryParam = NugetV2ODataUtils.extractIsLatestVersionQueryParam(query);
        if (isLatestVersionQueryParam.booleanValue()) {
            return assets.filter(asset -> {
                Map formatAttributes = FormatAttributesUtils.getFormatAttributes((Asset)asset, (String)"nuget");
                Optional<Boolean> value = NugetV2ODataUtils.extractBooleanValue(formatAttributes, "is_latest_version");
                return value.isPresent() && value.get() != false;
            });
        }
        return assets;
    }

    private Stream<Asset> applyIsAbsoluteLatestVersionFilter(Stream<Asset> assets, Map<String, String> query) {
        Boolean isAbsoluteLatestVersionQueryParam = NugetV2ODataUtils.extractIsAbsoluteLatestVersionQueryParam(query);
        if (isAbsoluteLatestVersionQueryParam.booleanValue()) {
            return assets.filter(asset -> {
                Map formatAttributes = FormatAttributesUtils.getFormatAttributes((Asset)asset, (String)"nuget");
                Optional<Boolean> value = NugetV2ODataUtils.extractBooleanValue(formatAttributes, "is_absolute_latest_version");
                return value.isPresent() && value.get() != false;
            });
        }
        return assets;
    }

    private Stream<Asset> applySearchTermsFilter(Stream<Asset> assets, Map<String, String> query) {
        List<String> searchTerms = NugetV2ODataUtils.extractSearchTerms(query);
        if (CollectionUtils.isEmpty(searchTerms)) {
            return assets;
        }
        return assets.filter(asset -> {
            Map formatAttributes = FormatAttributesUtils.getFormatAttributes((Asset)asset, (String)"nuget");
            Object keywordsValue = formatAttributes.get("keywords");
            if (keywordsValue == null) {
                return false;
            }
            String keywords = (String)keywordsValue;
            return searchTerms.stream().anyMatch(searchTerm -> keywords.contains((CharSequence)searchTerm));
        });
    }
}

