/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal.v2;

import com.sonatype.nexus.repository.nuget.datastore.internal.v2.NugetV2GalleryFacet;
import com.sonatype.nexus.repository.nuget.datastore.internal.v2.NugetV2ODataUtils;
import com.sonatype.nexus.repository.nuget.internal.AbstractNugetHandler;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Parameters;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class NugetV2FeedHandler
extends AbstractNugetHandler {
    public static final String FEED_PATTERN = "/{operation:[^/()]+}{parens:\\\\Q()\\\\E|}";
    public static final String FEED_COUNT_PATTERN = "/{operation:[^/()]+}{parens:\\\\Q()\\\\E|}/$count";
    public static final String PACKAGE_ENTRY_PATTERN = "/Packages(Id='{id}',Version='{version}')";
    public static final String PACKAGE_VERSIONS_PATTERN = "/package-versions/{id}";

    @Override
    protected Response doHandle(Context context) throws Exception {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        switch (state.pattern()) {
            case "/{operation:[^/()]+}{parens:\\\\Q()\\\\E|}": {
                return this.feed(context);
            }
            case "/{operation:[^/()]+}{parens:\\\\Q()\\\\E|}/$count": {
                return this.feedCount(context);
            }
            case "/Packages(Id='{id}',Version='{version}')": {
                return this.packageEntry(context);
            }
            case "/package-versions/{id}": {
                return this.packageVersions(context);
            }
        }
        throw new IllegalStateException("Unexpected path pattern passed to " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    private Response packageEntry(Context context) {
        Map tokens = ((TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class)).getTokens();
        String id = (String)tokens.get("id");
        String version = (String)tokens.get("version");
        String repositoryBaseURL = this.getRepositoryBase(context);
        String entry = ((NugetV2GalleryFacet)context.getRepository().facet(NugetV2GalleryFacet.class)).entry(repositoryBaseURL, id, version).orElse(null);
        if (entry == null) {
            return HttpResponses.notFound();
        }
        return this.xmlPayload(200, entry);
    }

    private Response feed(Context context) {
        Map tokens = ((TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class)).getTokens();
        Parameters queryParameters = context.getRequest().getParameters();
        String repositoryBaseURL = this.getRepositoryBase(context);
        String operation = (String)tokens.get("operation");
        Map<String, String> queryParametersMap = NugetV2ODataUtils.asMap(queryParameters);
        String feed = ((NugetV2GalleryFacet)context.getRepository().facet(NugetV2GalleryFacet.class)).feed(repositoryBaseURL, operation, queryParametersMap);
        return this.xmlPayload(200, feed);
    }

    private Response packageVersions(Context context) {
        Map tokens = ((TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class)).getTokens();
        Parameters queryParameters = context.getRequest().getParameters();
        Map<String, String> queryParametersMap = NugetV2ODataUtils.asMap(queryParameters);
        String id = (String)tokens.get("id");
        String versions = ((NugetV2GalleryFacet)context.getRepository().facet(NugetV2GalleryFacet.class)).packageVersions(id, queryParametersMap);
        return HttpResponses.ok((Payload)new StringPayload(versions, "application/json"));
    }

    private Response feedCount(Context context) {
        String operation = context.getRequest().getPath().substring(1);
        Parameters queryParameters = context.getRequest().getParameters();
        Map<String, String> queryParametersMap = NugetV2ODataUtils.asMap(queryParameters);
        int count = ((NugetV2GalleryFacet)context.getRepository().facet(NugetV2GalleryFacet.class)).count(operation, queryParametersMap);
        return HttpResponses.ok((Payload)new StringPayload(Integer.toString(count), "text/plain"));
    }
}

