/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.NugetPackagePathParser;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.elasticsearch.search.lookup.SourceLookup;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.security.AssetVariableResolverSupport;
import org.sonatype.nexus.repository.search.AssetSearchResult;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.selector.VariableSourceBuilder;

@Named(value="nuget")
public class NugetVariableResolverAdapter
extends AssetVariableResolverSupport {
    private final NugetPackagePathParser nugetPackagePathParser;

    @Inject
    public NugetVariableResolverAdapter(@Named(value="nuget") @Named(value="nuget") NugetPackagePathParser nugetPackagePathParser) {
        this.nugetPackagePathParser = (NugetPackagePathParser)Preconditions.checkNotNull((Object)nugetPackagePathParser);
    }

    protected void addFromSourceLookup(VariableSourceBuilder builder, SourceLookup sourceLookup, Map<String, Object> asset) {
        this.addNugetCoordinates(builder, (String)asset.get("name"));
    }

    protected void addFromSearchResults(VariableSourceBuilder builder, ComponentSearchResult component, AssetSearchResult asset) {
        this.addNugetCoordinates(builder, asset.getPath());
    }

    protected void addFromRequest(VariableSourceBuilder builder, Request request) {
        Preconditions.checkNotNull((Object)request);
        this.addNugetCoordinates(builder, request.getPath());
    }

    protected void addFromAsset(VariableSourceBuilder builder, FluentAsset asset) {
        Preconditions.checkNotNull((Object)asset);
        this.addNugetCoordinates(builder, asset.path());
    }

    private void addNugetCoordinates(VariableSourceBuilder builder, String path) {
        Preconditions.checkNotNull((Object)builder);
        Preconditions.checkNotNull((Object)path);
        NugetPackageCoords coords = this.nugetPackagePathParser.parsePath(path);
        if (coords != null) {
            HashMap<String, String> coordMap = new HashMap<String, String>();
            coordMap.put("id", coords.getId());
            coordMap.put("version", coords.getVersion());
            this.addCoordinates(builder, coordMap);
        }
    }
}

