/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyRepositorySignaturesFacet;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyUtil;
import com.sonatype.nexus.repository.nuget.v3.models.Certificate;
import com.sonatype.nexus.repository.nuget.v3.models.RepositorySignaturesIndex;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;

@Facet.Exposed
public class NugetV3ProxyRepositorySignaturesFacetImpl
extends FacetSupport
implements NugetV3ProxyRepositorySignaturesFacet {
    private final ObjectMapper objectMapper;

    @Inject
    public NugetV3ProxyRepositorySignaturesFacetImpl(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    @Override
    public Optional<RepositorySignaturesIndex> getRepositorySignaturesIndex(String assetPath) {
        Optional<FluentAsset> assetOptional = this.getRepositorySignaturesIndexAsset(assetPath);
        return assetOptional.filter(Asset::hasBlob).map(asset -> this.serializeRepositorySignaturesIndex((Payload)asset.download()));
    }

    @Override
    public Optional<Certificate> getRepositorySignaturesCertificate(RepositorySignaturesIndex repositorySignaturesIndex, String certificateFingerprint) {
        return repositorySignaturesIndex.getSigningCertificates().stream().filter(certificate -> certificate.getFingerprints().getValue().equals(certificateFingerprint)).findAny();
    }

    private Optional<FluentAsset> getRepositorySignaturesIndexAsset(String assetPath) {
        return ((ContentFacet)this.facet(ContentFacet.class)).assets().path(StringUtils.prependIfMissing((String)assetPath, (CharSequence)"/", (CharSequence[])new CharSequence[0])).find();
    }

    @Override
    public Content rewriteRepositorySignaturesIndex(Content content, String repositorySignaturesPath) {
        RepositorySignaturesIndex repositorySignaturesIndex = this.serializeRepositorySignaturesIndex((Payload)content);
        NugetV3ProxyUtil.rewriteRepositorySignaturesIndex(repositorySignaturesIndex, repositorySignaturesPath, this.getRepository().getUrl());
        byte[] body = this.deserializeRepositorySignaturesIndex(repositorySignaturesIndex);
        BytesPayload bytesPayload = new BytesPayload(body, content.getContentType());
        Content newContent = new Content((Payload)bytesPayload);
        newContent.getAttributes().backing().putAll(content.getAttributes().backing());
        return newContent;
    }

    private byte[] deserializeRepositorySignaturesIndex(RepositorySignaturesIndex repositorySignaturesIndex) {
        try {
            return this.objectMapper.writeValueAsBytes((Object)repositorySignaturesIndex);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private RepositorySignaturesIndex serializeRepositorySignaturesIndex(Payload payload) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = payload.openInputStream();){
                return (RepositorySignaturesIndex)this.objectMapper.readValue(inputStream, RepositorySignaturesIndex.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

