/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.datastore.NugetAssetUtils;
import com.sonatype.nexus.repository.nuget.datastore.NugetContentFacet;
import com.sonatype.nexus.repository.nuget.datastore.internal.NugetProxyDispatcherFacet;
import com.sonatype.nexus.repository.nuget.datastore.internal.NugetV3ProxyRewriteUrlsMetadataProcessor;
import com.sonatype.nexus.repository.nuget.internal.NugetHandlerUtils;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyPackageContentFacet;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyRepositorySignaturesFacet;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyUtil;
import com.sonatype.nexus.repository.nuget.internal.v3.routing.NugetContentMatcher;
import com.sonatype.nexus.repository.nuget.internal.v3.routing.NugetMetadataMatcher;
import com.sonatype.nexus.repository.nuget.v3.AssetKind;
import com.sonatype.nexus.repository.nuget.v3.NugetV3ServiceIndexFacet;
import com.sonatype.nexus.repository.nuget.v3.models.Certificate;
import com.sonatype.nexus.repository.nuget.v3.models.RepositorySignaturesIndex;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceIndex;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.RepositoryEvent;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheControllerHolder;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.manager.RepositoryUpdatedEvent;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.types.ProxyType;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;

@Facet.Exposed
@Named
public class NugetV3ProxyFacet
extends FacetSupport {
    private final NugetV3ProxyRewriteUrlsMetadataProcessor metadataProcessor;

    @Inject
    public NugetV3ProxyFacet(NugetV3ProxyRewriteUrlsMetadataProcessor metadataProcessor) {
        this.metadataProcessor = metadataProcessor;
    }

    public Content get(Context context) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        if (assetKind == AssetKind.PACKAGE) {
            NugetPackageCoords coords = NugetHandlerUtils.getPackageCoordinates(context);
            return ((NugetContentFacet)this.facet(NugetContentFacet.class)).get(coords.getId(), coords.getVersion()).orElse(null);
        }
        Content original = ((NugetProxyDispatcherFacet)this.facet(NugetProxyDispatcherFacet.class)).getSuper(context);
        if (original == null) {
            return null;
        }
        boolean returnsOriginalContentParam = this.getReturnsOriginalContentParam(context);
        if (returnsOriginalContentParam) {
            return original;
        }
        if (this.metadataProcessor.isMetadataRewritable(assetKind)) {
            return this.metadataProcessor.rewriteUrls(context, original);
        }
        return original;
    }

    public URI normalizeURLPath(URI remoteURI) {
        return remoteURI;
    }

    @Nonnull
    protected CacheController getCacheController(@Nonnull Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        CacheControllerHolder cacheControllerHolder = ((NugetProxyDispatcherFacet)this.facet(NugetProxyDispatcherFacet.class)).getCacheControllerHolder();
        return cacheControllerHolder.require(assetKind.getCacheType());
    }

    @Nullable
    protected Content getCachedContent(Context context) {
        String assetName = NugetAssetUtils.assetName(context);
        return ((NugetContentFacet)this.facet(NugetContentFacet.class)).findAsset(assetName).flatMap(asset -> ((NugetContentFacet)this.facet(NugetContentFacet.class)).download((FluentAsset)asset)).orElse(null);
    }

    public Content store(Context context, Content content) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        switch (assetKind) {
            case SERVICE_INDEX: {
                return this.storeServiceIndex(content);
            }
            case CONTENT: {
                String packageId = NugetContentMatcher.getContentPackageId(context);
                String version = NugetContentMatcher.getContentVersion(context);
                return ((NugetContentFacet)this.facet(NugetContentFacet.class)).putPackage(packageId, version, (Payload)content).download();
            }
        }
        String assetName = NugetAssetUtils.assetName(context);
        return ((NugetContentFacet)this.facet(NugetContentFacet.class)).putMetadata(assetName, (Payload)content).download();
    }

    public void indicateVerified(Context context, Content content, CacheInfo cacheInfo) throws IOException {
        Preconditions.checkNotNull((Object)cacheInfo);
        String assetName = NugetAssetUtils.assetName(context);
        Optional<FluentAsset> fluentAsset = ((NugetContentFacet)this.facet(NugetContentFacet.class)).findAsset(assetName);
        if (!fluentAsset.isPresent()) {
            this.log.debug("Attempting to set cache info for non-existent nuget asset: {} on repository: {}", (Object)assetName, (Object)this.getRepository().getName());
            return;
        }
        FluentAsset asset = fluentAsset.get();
        this.log.debug("Updating cacheInfo for asset: {} on repository: {} to {}", new Object[]{asset.path(), this.getRepository().getName(), cacheInfo});
        asset.markAsCached(cacheInfo);
    }

    public String getUrl(@Nonnull Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        try {
            switch (assetKind) {
                case SERVICE_INDEX: {
                    return ((ProxyFacet)this.facet(ProxyFacet.class)).getRemoteUrl().toString();
                }
                case REGISTRATION_INDEX: {
                    return NugetV3ProxyUtil.buildRemoteUri(context, NugetV3ProxyUtil.joinPath(NugetMetadataMatcher.getMetadataPackageId(context), "index.json")).toString();
                }
                case REGISTRATION_PAGE: 
                case REGISTRATION_LEAF: {
                    return NugetV3ProxyUtil.buildRemoteUri(context, NugetMetadataMatcher.getMetadataPath(context)).toString();
                }
                case VERSIONS: {
                    return NugetV3ProxyUtil.buildRemoteUri(context, NugetV3ProxyUtil.joinPath(NugetContentMatcher.getContentPackageId(context), "index.json")).toString();
                }
                case MANIFEST: {
                    String id = NugetContentMatcher.getContentPackageId(context);
                    String version = NugetContentMatcher.getContentVersion(context);
                    return NugetV3ProxyUtil.buildRemoteUri(context, NugetV3ProxyUtil.joinPath(id, version, String.valueOf(id) + ".nuspec")).toString();
                }
                case CONTENT: {
                    String id = NugetContentMatcher.getContentPackageId(context);
                    String version = NugetContentMatcher.getContentVersion(context);
                    Optional<URI> uri = NugetV3ProxyUtil.buildRemoteUriOptional(context, NugetV3ProxyUtil.joinPath(id, version, String.valueOf(id) + "." + version + ".nupkg"));
                    if (uri.isPresent()) {
                        return uri.get().toString();
                    }
                    return ((NugetV3ProxyPackageContentFacet)this.facet(NugetV3ProxyPackageContentFacet.class)).lookForPackageContentUrlInMetadataFiles(id, version).orElse(null);
                }
                case REPOSITORY_SIGNATURES: {
                    return NugetV3ProxyUtil.buildRemoteUri(context).toString();
                }
                case REPOSITORY_SIGNATURES_CERTIFICATES: {
                    return this.getCertificateUrl(context);
                }
            }
            throw new RuntimeException("Unsupported type: " + ((AssetKind)((Object)context.getAttributes().require(AssetKind.class))).name());
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException("Unable to build remote URL for request: " + context.getRequest(), e);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryEvent event) {
        if (this.shouldRemoveServiceIndex(event)) {
            this.optionalFacet(NugetV3ServiceIndexFacet.class).ifPresent(NugetV3ServiceIndexFacet::removeServiceIndex);
        }
    }

    private boolean shouldRemoveServiceIndex(RepositoryEvent event) {
        if (event.getRepository().getType() instanceof ProxyType && event instanceof RepositoryUpdatedEvent) {
            String currentUrl;
            Map oldConfiguration = Objects.requireNonNull(((RepositoryUpdatedEvent)event).getOldConfiguration().getAttributes());
            String previousUrl = NugetV3ProxyUtil.trimSlashes(((Map)oldConfiguration.get("proxy")).get("remoteUrl").toString());
            return !previousUrl.equals(currentUrl = NugetV3ProxyUtil.trimSlashes(((ProxyFacet)this.facet(ProxyFacet.class)).getRemoteUrl().toString()));
        }
        return false;
    }

    private String getCertificateUrl(Context context) {
        RepositorySignaturesIndex repositorySignaturesIndex = (RepositorySignaturesIndex)context.getAttributes().get(RepositorySignaturesIndex.class);
        if (repositorySignaturesIndex != null) {
            String certificateFingerprint = NugetMetadataMatcher.getCertificateFingerprint(context);
            return ((NugetV3ProxyRepositorySignaturesFacet)this.facet(NugetV3ProxyRepositorySignaturesFacet.class)).getRepositorySignaturesCertificate(repositorySignaturesIndex, certificateFingerprint).map(Certificate::getContentUrl).orElse(null);
        }
        return null;
    }

    private Content storeServiceIndex(Content content) throws IOException {
        ServiceIndex serviceIndex = NugetAssetUtils.serialize((Payload)content, ServiceIndex.class);
        ServiceIndex upstreamServiceIndex = NugetV3ProxyUtil.toUpstreamServiceIndex(serviceIndex);
        Content upstreamContent = NugetAssetUtils.asJsonContent(upstreamServiceIndex);
        NugetAssetUtils.copyAttributes(content, upstreamContent);
        return ((NugetContentFacet)this.facet(NugetContentFacet.class)).putMetadata("/index.json", (Payload)upstreamContent).download();
    }

    private boolean getReturnsOriginalContentParam(Context context) {
        Boolean obj = (Boolean)context.getAttributes().get("RETURNS_ORIGINAL_CONTENT", Boolean.class);
        return Boolean.TRUE.equals(obj);
    }
}

