/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal;

import com.sonatype.nexus.repository.nuget.NugetVersion;
import com.sonatype.nexus.repository.nuget.datastore.internal.NugetV3ProxyFacet;
import com.sonatype.nexus.repository.nuget.datastore.internal.v2.NugetV2ProxyFacet;
import com.sonatype.nexus.repository.nuget.datastore.internal.v2.NugetV2RemoteGalleryFacet;
import java.io.IOException;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheControllerHolder;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;

@Named
@Facet.Exposed
public class NugetProxyDispatcherFacet
extends ProxyFacetSupport {
    public void invalidateProxyCaches() {
        super.invalidateProxyCaches();
        NugetVersion nugetVersion = this.getNugetVersion();
        if (nugetVersion == NugetVersion.V2) {
            ((NugetV2RemoteGalleryFacet)this.facet(NugetV2RemoteGalleryFacet.class)).invalidateCaches();
        }
    }

    public Content get(Context context) throws IOException {
        NugetVersion nugetVersion = this.getNugetVersion();
        switch (nugetVersion) {
            case V3: {
                return ((NugetV3ProxyFacet)this.facet(NugetV3ProxyFacet.class)).get(context);
            }
            case V2: {
                return super.get(context);
            }
        }
        throw new UnsupportedOperationException("Unsupported nuget version " + (Object)((Object)nugetVersion));
    }

    public Content getSuper(Context context) throws IOException {
        return super.get(context);
    }

    protected URI normalizeURLPath(URI remoteURI) {
        NugetVersion nugetVersion = this.getNugetVersion();
        switch (nugetVersion) {
            case V3: {
                return ((NugetV3ProxyFacet)this.facet(NugetV3ProxyFacet.class)).normalizeURLPath(remoteURI);
            }
            case V2: {
                return super.normalizeURLPath(remoteURI);
            }
        }
        throw new UnsupportedOperationException("Unsupported nuget version " + (Object)((Object)nugetVersion));
    }

    @Nullable
    protected Content getCachedContent(Context context) throws IOException {
        NugetVersion nugetVersion = this.getNugetVersion();
        switch (nugetVersion) {
            case V3: {
                return ((NugetV3ProxyFacet)this.facet(NugetV3ProxyFacet.class)).getCachedContent(context);
            }
            case V2: {
                return ((NugetV2ProxyFacet)this.facet(NugetV2ProxyFacet.class)).getCachedContent(context);
            }
        }
        throw new UnsupportedOperationException("Unsupported nuget version " + (Object)((Object)nugetVersion));
    }

    protected Content store(Context context, Content content) throws IOException {
        NugetVersion nugetVersion = this.getNugetVersion();
        switch (nugetVersion) {
            case V3: {
                return ((NugetV3ProxyFacet)this.facet(NugetV3ProxyFacet.class)).store(context, content);
            }
            case V2: {
                return ((NugetV2ProxyFacet)this.facet(NugetV2ProxyFacet.class)).store(context, content);
            }
        }
        throw new UnsupportedOperationException("Unsupported nuget version " + (Object)((Object)nugetVersion));
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) throws IOException {
        NugetVersion nugetVersion = this.getNugetVersion();
        switch (nugetVersion) {
            case V3: {
                ((NugetV3ProxyFacet)this.facet(NugetV3ProxyFacet.class)).indicateVerified(context, content, cacheInfo);
                break;
            }
            case V2: {
                ((NugetV2ProxyFacet)this.facet(NugetV2ProxyFacet.class)).indicateVerified(context, content, cacheInfo);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported nuget version " + (Object)((Object)nugetVersion));
            }
        }
    }

    @Nonnull
    protected CacheController getCacheController(@Nonnull Context context) {
        NugetVersion nugetVersion = this.getNugetVersion();
        switch (nugetVersion) {
            case V3: {
                return ((NugetV3ProxyFacet)this.facet(NugetV3ProxyFacet.class)).getCacheController(context);
            }
            case V2: {
                return super.getCacheController(context);
            }
        }
        throw new UnsupportedOperationException("Unsupported nuget version " + (Object)((Object)nugetVersion));
    }

    public CacheControllerHolder getCacheControllerHolder() {
        return this.cacheControllerHolder;
    }

    protected String getUrl(@Nonnull Context context) {
        NugetVersion nugetVersion = this.getNugetVersion();
        switch (nugetVersion) {
            case V3: {
                return ((NugetV3ProxyFacet)this.facet(NugetV3ProxyFacet.class)).getUrl(context);
            }
            case V2: {
                return ((NugetV2ProxyFacet)this.facet(NugetV2ProxyFacet.class)).getUrl(context);
            }
        }
        throw new UnsupportedOperationException("Unsupported nuget version " + (Object)((Object)nugetVersion));
    }

    @Nullable
    protected Content fetch(Context context, Content stale) throws IOException {
        NugetVersion nugetVersion = this.getNugetVersion();
        switch (nugetVersion) {
            case V3: {
                return super.fetch(context, stale);
            }
            case V2: {
                return ((NugetV2ProxyFacet)this.facet(NugetV2ProxyFacet.class)).fetch(context, stale);
            }
        }
        throw new UnsupportedOperationException("Unsupported nuget version " + (Object)((Object)nugetVersion));
    }

    public Content fetch(String url, Context context, @Nullable Content stale) throws IOException {
        if (url == null) {
            return null;
        }
        return super.fetch(url, context, stale);
    }

    private NugetVersion getNugetVersion() {
        String nugetVersionAttribute = (String)this.getRepository().getConfiguration().attributes("nugetProxy").get("nugetVersion", String.class);
        if (NugetVersion.V3.name().equals(nugetVersionAttribute)) {
            return NugetVersion.V3;
        }
        return NugetVersion.V2;
    }
}

