/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal;

import com.google.common.collect.Sets;
import com.sonatype.nexus.repository.nuget.datastore.NugetContentFacet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionScheme;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.utils.FormatAttributesUtils;

@Named
@Singleton
public class NugetMaintainAggregateInfo {
    public static final Comparator<FluentComponent> VERSION_COMPARATOR = new ComponentVersionComparator();

    public void maintainAggregateInfo(Repository repository, Iterable<String> packageIds) {
        List<FluentComponent> components = StreamSupport.stream(packageIds.spliterator(), false).flatMap(packageId -> ((NugetContentFacet)repository.facet(NugetContentFacet.class)).findComponents((String)packageId).stream()).collect(Collectors.toList());
        this.maintainAggregateInfo(components);
    }

    public void maintainAggregateInfo(Repository repository, Component component) {
        List<FluentComponent> components = ((NugetContentFacet)repository.facet(NugetContentFacet.class)).findComponents(component.name());
        this.maintainAggregateInfo(components);
    }

    public void maintainAggregateInfo(Iterable<FluentComponent> iterable) {
        Map<String, List<FluentComponent>> groupByNameComponents = StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.groupingBy(component -> component.name()));
        for (Map.Entry<String, List<FluentComponent>> entry : groupByNameComponents.entrySet()) {
            List<FluentComponent> components = entry.getValue();
            TreeSet releases = Sets.newTreeSet(VERSION_COMPARATOR);
            TreeSet allReleases = Sets.newTreeSet(VERSION_COMPARATOR);
            Map<String, Collection> assetsPerComponentsVersions = components.stream().collect(Collectors.toMap(Component::version, FluentComponent::assets));
            components.forEach(component -> ((Collection)assetsPerComponentsVersions.get(component.version())).stream().findFirst().ifPresent(fluentAsset -> {
                Map attributes = FormatAttributesUtils.getFormatAttributes((FluentAsset)fluentAsset);
                boolean isPreRelease = attributes.getOrDefault("is_prerelease", false);
                if (!isPreRelease) {
                    releases.add(component);
                }
                allReleases.add(component);
            }));
            FluentComponent latestVersion = releases.isEmpty() ? null : (FluentComponent)releases.last();
            FluentComponent absoluteLatestVersion = allReleases.isEmpty() ? null : (FluentComponent)allReleases.last();
            allReleases.forEach(component -> ((Collection)assetsPerComponentsVersions.get(component.version())).stream().findFirst().ifPresent(fluentAsset -> {
                Map attributes = FormatAttributesUtils.getFormatAttributes((FluentAsset)fluentAsset);
                boolean latest = component.equals(latestVersion);
                boolean absoluteLatest = component.equals(absoluteLatestVersion);
                boolean needsUpdate = false;
                if (this.isAttributeChanged("is_latest_version", attributes, latest)) {
                    attributes.put("is_latest_version", latest);
                    needsUpdate = true;
                }
                if (this.isAttributeChanged("is_absolute_latest_version", attributes, absoluteLatest)) {
                    attributes.put("is_absolute_latest_version", absoluteLatest);
                    needsUpdate = true;
                }
                if (attributes.get("download_count") == null) {
                    attributes.put("download_count", 0);
                    needsUpdate = true;
                }
                if (attributes.get("version_download_count") == null) {
                    attributes.put("version_download_count", 0);
                    needsUpdate = true;
                }
                if (needsUpdate) {
                    fluentAsset.attributes(AttributeOperation.OVERLAY, "nuget", (Object)attributes);
                }
            }));
        }
    }

    public boolean isPreRelease(String version) {
        int prereleaseIdx = version.indexOf(45);
        int metadataIdx = version.indexOf(43);
        return prereleaseIdx > 0 && (metadataIdx == -1 || prereleaseIdx < metadataIdx);
    }

    private boolean isAttributeChanged(String key, Map<String, Object> attributes, boolean current) {
        Object value = attributes.get(key);
        return !(value instanceof Boolean) || (Boolean)value != current;
    }

    private static class ComponentVersionComparator
    implements Comparator<FluentComponent> {
        private static final VersionScheme SCHEME = new GenericVersionScheme();

        private ComponentVersionComparator() {
        }

        @Override
        public int compare(FluentComponent o1, FluentComponent o2) {
            try {
                Version v1 = SCHEME.parseVersion(o1.version());
                Version v2 = SCHEME.parseVersion(o2.version());
                return v1.compareTo((Object)v2);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

