/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.datastore.NugetAssetUtils;
import com.sonatype.nexus.repository.nuget.datastore.NugetContentFacet;
import com.sonatype.nexus.repository.nuget.datastore.internal.NugetMaintainAggregateInfo;
import com.sonatype.nexus.repository.nuget.datastore.internal.v2.NugetV2ODataUtils;
import com.sonatype.nexus.repository.nuget.datastore.store.NugetAssetStore;
import com.sonatype.nexus.repository.nuget.datastore.store.NugetComponentStore;
import com.sonatype.nexus.repository.nuget.internal.NugetDataUtils;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import com.sonatype.nexus.repository.nuget.odata.ODataTemplates;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.repository.MissingBlobException;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.content.maintenance.ContentMaintenanceFacet;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.content.utils.FormatAttributesUtils;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="nuget")
public class NugetContentFacetImpl
extends ContentFacetSupport
implements NugetContentFacet {
    private final Clock clock;
    private final NugetMaintainAggregateInfo nugetMaintainAggregateInfo;

    @Inject
    protected NugetContentFacetImpl(@Named(value="nuget") @Named(value="nuget") FormatStoreManager formatStoreManager, NugetMaintainAggregateInfo nugetMaintainAggregateInfo, Clock clock) {
        super(formatStoreManager);
        this.nugetMaintainAggregateInfo = (NugetMaintainAggregateInfo)Preconditions.checkNotNull((Object)nugetMaintainAggregateInfo);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
    }

    @Override
    public Optional<Content> get(String packageId, String version) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)version);
        return this.findAsset(packageId, version).map(FluentAsset::download);
    }

    @Override
    public FluentAsset putPackage(String packageId, String version, Payload payload) {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)version);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob blob = this.blobs().ingest(payload, NugetPackageUtils.HASH_ALGORITHMS);){
            ImmutableMap formatAttributes = ImmutableMap.of((Object)"id", (Object)packageId, (Object)"version", (Object)version);
            Map<String, Object> assetAttributes = Collections.singletonMap("is_prerelease", this.nugetMaintainAggregateInfo.isPreRelease(version));
            FluentAsset asset = this.putPackage(packageId, version, blob, (Map<String, String>)formatAttributes, assetAttributes);
            return asset.markAsCached(payload);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public FluentAsset putPackage(String packageId, String version, TempBlob tempBlob, Map<String, String> componentAttributes, Map<String, Object> assetAttributes) {
        FluentComponent component = this.findGetCreateComponent(packageId, version, componentAttributes);
        String assetName = new NugetPackageCoords(component.name(), component.version()).toPath();
        FluentAsset asset = this.getOrCreatePackageAsset(assetName, component, assetAttributes, tempBlob);
        this.nugetMaintainAggregateInfo.maintainAggregateInfo(this.repository(), (Component)component);
        return asset;
    }

    @Override
    public FluentAsset putHardlinkPackage(String packageId, String version, Blob assetBlob, Map<String, String> componentAttributes, Map<String, Object> assetAttributes, Map<HashAlgorithm, HashCode> checksums) {
        FluentComponent component = this.findGetCreateComponent(packageId, version, componentAttributes);
        String assetName = new NugetPackageCoords(component.name(), component.version()).toPath();
        FluentAsset asset = this.hardlinkCreateAsset(assetName, component, assetAttributes, assetBlob, checksums);
        this.nugetMaintainAggregateInfo.maintainAggregateInfo(this.repository(), (Component)component);
        return asset;
    }

    @Override
    public FluentAsset putMetadata(String assetPath, Payload payload) {
        Preconditions.checkNotNull((Object)payload);
        Preconditions.checkNotNull((Object)assetPath);
        this.setContentLastModified(payload);
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, NugetPackageUtils.HASH_ALGORITHMS);){
            return this.assets().path(assetPath).blob(tempBlob).save().markAsCached(payload);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean delete(String packageId, String version) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)version);
        ContentMaintenanceFacet maintenanceFacet = (ContentMaintenanceFacet)this.getRepository().facet(ContentMaintenanceFacet.class);
        return this.findComponent(packageId, version).map(arg_0 -> ((ContentMaintenanceFacet)maintenanceFacet).deleteComponent(arg_0)).map(deletedPaths -> !deletedPaths.isEmpty()).orElse(Boolean.FALSE);
    }

    @Override
    public Iterable<FluentComponent> findComponents() {
        return Continuations.iterableOf((arg_0, arg_1) -> ((FluentComponents)this.components()).browse(arg_0, arg_1));
    }

    @Override
    public Iterable<Asset> findAssets() {
        NugetAssetStore nugetAssetStore = (NugetAssetStore)this.stores().assetStore;
        return Continuations.iterableOf((limit, continuationToken) -> nugetAssetStore.browseAssets(this.contentRepositoryId(), (String)continuationToken, null, null, null, (int)limit));
    }

    @Override
    public List<FluentComponent> findComponents(String packageId) {
        Preconditions.checkNotNull((Object)packageId);
        NugetComponentStore nugetComponentStore = (NugetComponentStore)this.stores().componentStore;
        return nugetComponentStore.findComponentsCaseInsensitive(this.getRepository(), packageId).stream().map(component -> this.components().with(component)).collect(Collectors.toList());
    }

    @Override
    public Iterable<Asset> findAssetsByComponentName(String packageId) {
        NugetAssetStore nugetAssetStore = (NugetAssetStore)this.stores().assetStore;
        return Continuations.iterableOf((limit, continuationToken) -> nugetAssetStore.findAssetsByComponentName(this.getRepository(), packageId, (int)limit, (String)continuationToken));
    }

    @Override
    public Optional<FluentComponent> findComponent(String packageId, String version) {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)version);
        NugetComponentStore nugetComponentStore = (NugetComponentStore)this.stores().componentStore;
        return nugetComponentStore.findComponentsCaseInsensitive(this.getRepository(), packageId, version).stream().map(component -> this.components().with(component)).findAny();
    }

    @Override
    public Optional<FluentAsset> findAsset(String packageId, String version) {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)version);
        return this.findComponent(packageId, version).map(FluentComponent::assets).map(Collection::stream).flatMap(Stream::findFirst);
    }

    @Override
    public Optional<FluentAsset> findAsset(String assetPath) {
        Preconditions.checkNotNull((Object)assetPath);
        return this.assets().path(assetPath).find();
    }

    @Override
    public Optional<FluentAsset> getServiceIndex() {
        return this.assets().path("/index.json").find();
    }

    @Override
    public void putV2Metadata(Iterable<Map<String, String>> metadata) {
        for (Map<String, String> value : metadata) {
            this.putV2Metadata(value);
        }
        Set<String> packageIds = StreamSupport.stream(metadata.spliterator(), false).map(it -> (String)it.get("ID")).collect(Collectors.toSet());
        this.nugetMaintainAggregateInfo.maintainAggregateInfo(this.getRepository(), packageIds);
    }

    @Override
    public Optional<Content> download(@Nullable FluentAsset fluentAsset) {
        if (fluentAsset == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(fluentAsset.download());
        }
        catch (MissingBlobException e) {
            this.log.warn("Unable to download content. Repository {} asset {}.", new Object[]{fluentAsset.repository().getName(), fluentAsset.path(), this.log.isDebugEnabled() ? e : null});
            return Optional.empty();
        }
    }

    private FluentAsset putV2Metadata(Map<String, String> metadata) {
        String version;
        String id = Objects.requireNonNull(metadata.get("ID"));
        Optional<FluentComponent> lookupComponent = this.findComponent(id, version = NugetDataUtils.checkVersion(NugetDataUtils.normalizeVersion(metadata)));
        boolean isNewComponent = !lookupComponent.isPresent();
        FluentComponent componentMetadata = this.createOrUpdateV2MetadataComponent(metadata, lookupComponent);
        String assetPath = String.format("/%s/%s", id, version);
        return this.createOrUpdateV2MetadataAsset(assetPath, isNewComponent, componentMetadata, metadata);
    }

    private FluentComponent createOrUpdateV2MetadataComponent(Map<String, String> metadata, Optional<FluentComponent> fluentComponent) {
        String id = Objects.requireNonNull(metadata.get("ID"));
        String version = NugetDataUtils.checkVersion(NugetDataUtils.normalizeVersion(metadata));
        Map<String, String> componentFormatAttributes = NugetV2ODataUtils.extractComponentFormatAttributes(metadata);
        return fluentComponent.map(component -> (FluentComponent)component.withAttribute("nuget", (Object)componentFormatAttributes)).orElseGet(() -> this.getOrCreateComponent(id, version, componentFormatAttributes));
    }

    private FluentAsset createOrUpdateV2MetadataAsset(String assetPath, boolean isNewComponent, FluentComponent component, Map<String, String> metadata) {
        return component.assets().stream().findFirst().map(fluentAsset -> {
            Map currentAssetFormatAttribute = FormatAttributesUtils.getFormatAttributes((FluentAsset)fluentAsset);
            Map<String, Object> newAssetFormatAttribute = this.buildV2AssetFormatAttribute(currentAssetFormatAttribute, metadata, isNewComponent);
            return (FluentAsset)fluentAsset.withAttribute("nuget", newAssetFormatAttribute);
        }).orElseGet(() -> {
            Map<String, Object> assetFormatAttribute = this.buildV2AssetFormatAttribute(Collections.emptyMap(), metadata, isNewComponent);
            return this.assets().path(assetPath).component((Component)component).attributes("nuget", assetFormatAttribute).save();
        });
    }

    private Map<String, Object> buildV2AssetFormatAttribute(Map<String, Object> currentAssetFormatAttribute, @Nullable Map<String, String> metadata, boolean componentIsNew) {
        if (metadata == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> formatAttributes = new HashMap<String, Object>(currentAssetFormatAttribute);
        this.setV2DerivedAttributes(metadata, formatAttributes, !componentIsNew);
        formatAttributes.putAll(NugetV2ODataUtils.extractAssetFormatAttributes(metadata));
        NugetV2ODataUtils.updateDerivedTextFields(formatAttributes);
        return formatAttributes;
    }

    @VisibleForTesting
    void setV2DerivedAttributes(Map<String, String> incomingMetadata, Map<String, Object> storedMetadata, boolean republishing) {
        if (!republishing) {
            if (this.isRepoAuthoritative()) {
                storedMetadata.put("download_count", 0);
                storedMetadata.put("version_download_count", 0);
            } else {
                storedMetadata.put("download_count", NugetV2ODataUtils.parseIntOrZero(incomingMetadata.get("DOWNLOADCOUNT")));
                storedMetadata.put("version_download_count", NugetV2ODataUtils.parseIntOrZero(incomingMetadata.get("VERSIONDOWNLOADCOUNT")));
            }
        }
        Date now = new Date(this.clock.millis());
        if (!republishing && this.isRepoAuthoritative()) {
            storedMetadata.put("created", now);
            storedMetadata.put("published", now);
        } else {
            storedMetadata.put("created", ODataTemplates.toDate(incomingMetadata.get("CREATED")));
            storedMetadata.put("published", ODataTemplates.toDate(incomingMetadata.get("PUBLISHED")));
        }
        String lastUpdated = incomingMetadata.get("LASTUPDATED");
        storedMetadata.put("last_updated", lastUpdated == null ? new Date() : ODataTemplates.toDate(lastUpdated));
    }

    private boolean isRepoAuthoritative() {
        return this.getRepository().getType() instanceof HostedType;
    }

    private void setContentLastModified(Payload payload) {
        if (payload instanceof Content) {
            Content content = (Content)payload;
            NugetAssetUtils.setLastModified(content);
        }
    }

    private FluentComponent findGetCreateComponent(String packageId, String version, Map<String, String> componentFormatAttributes) {
        return this.findComponent(packageId, version).orElseGet(() -> this.getOrCreateComponent(packageId, version, componentFormatAttributes));
    }

    private FluentComponent getOrCreateComponent(String packageId, String version, Map<String, String> componentFormatAttributes) {
        return this.components().name(packageId).version(version).normalizedVersion(this.versionNormalizerService().getNormalizedVersionByFormat(version, this.repository().getFormat())).attributes("nuget", componentFormatAttributes).getOrCreate();
    }

    private FluentAsset hardlinkCreateAsset(String name, FluentComponent component, Map<String, Object> attributes, Blob blob, Map<HashAlgorithm, HashCode> checksums) {
        return this.assets().path(name).component((Component)component).attributes("nuget", attributes).blob(blob, checksums).save();
    }

    private FluentAsset getOrCreatePackageAsset(String name, FluentComponent component, Map<String, Object> attributes, TempBlob tempBlob) {
        return component.assets().stream().findFirst().map(existingAsset -> ((FluentAsset)existingAsset.attributes(AttributeOperation.OVERLAY, "nuget", (Object)attributes)).attach(tempBlob)).orElseGet(() -> this.assets().path(name).component((Component)component).blob(tempBlob).attributes("nuget", (Object)attributes).save());
    }
}

