/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.nuget.datastore.internal.NugetMaintainAggregateInfo;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.director.ContentDirector;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;

@Named(value="nuget")
@Singleton
public class NugetContentDirector
implements ContentDirector {
    private final NugetMaintainAggregateInfo nugetMaintainAggregateInfo;

    @Inject
    public NugetContentDirector(NugetMaintainAggregateInfo nugetMaintainAggregateInfo) {
        this.nugetMaintainAggregateInfo = (NugetMaintainAggregateInfo)Preconditions.checkNotNull((Object)nugetMaintainAggregateInfo);
    }

    public boolean allowMoveTo(Repository destination) {
        return true;
    }

    public boolean allowMoveTo(FluentComponent component, Repository destination) {
        return true;
    }

    public boolean allowMoveFrom(Repository source) {
        return true;
    }

    public Component afterMove(Component component, Repository destination) {
        this.nugetMaintainAggregateInfo.maintainAggregateInfo(destination, component);
        return component;
    }
}

