/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.sonatype.nexus.repository.nuget.datastore.ContentNugetV3HostedFacet;
import com.sonatype.nexus.repository.nuget.datastore.NugetAssetUtils;
import com.sonatype.nexus.repository.nuget.datastore.NugetContentFacet;
import com.sonatype.nexus.repository.nuget.datastore.internal.v2.NugetV2ODataUtils;
import com.sonatype.nexus.repository.nuget.internal.NugetDataUtils;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3SemVerComparator;
import com.sonatype.nexus.repository.nuget.internal.v3.routing.NugetContentMatcher;
import com.sonatype.nexus.repository.nuget.odata.ODataFeedUtils;
import com.sonatype.nexus.repository.nuget.v3.AssetKind;
import com.sonatype.nexus.repository.nuget.v3.models.AvailableVersions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named
@Facet.Exposed
public class ContentNugetV3HostedFacetImpl
extends FacetSupport
implements ContentNugetV3HostedFacet {
    @Override
    public AvailableVersions getPackageVersions(String packageId) {
        List<String> versions = ((NugetContentFacet)this.facet(NugetContentFacet.class)).findComponents(packageId).stream().map(Component::version).sorted(NugetV3SemVerComparator.INSTANCE).collect(Collectors.toList());
        AvailableVersions availableVersions = new AvailableVersions();
        availableVersions.setVersions(versions);
        return availableVersions;
    }

    @Override
    public Optional<Content> getAssetContent(String packageId, String version) {
        try {
            Optional<Content> content = ((NugetContentFacet)this.facet(NugetContentFacet.class)).get(packageId, version);
            if (!content.isPresent()) {
                content = this.findByNormalizedVersion(packageId, version);
            }
            return content;
        }
        catch (IOException e) {
            this.log.error("Failed to get NuGet asset {}:{} from {}", new Object[]{packageId, version, this.getRepository().getName(), e});
            return Optional.empty();
        }
    }

    @Override
    public Content getItem(Context context) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        switch (assetKind) {
            case CONTENT: {
                return ((NugetContentFacet)this.getRepository().facet(NugetContentFacet.class)).get(NugetContentMatcher.getContentPackageId(context), NugetContentMatcher.getContentVersion(context)).orElse(null);
            }
            case REPOSITORY_SIGNATURES: {
                throw new UnsupportedOperationException("Proxy-only operation");
            }
            case SERVICE_INDEX: {
                throw new UnsupportedOperationException("Hosted generates service index on the fly");
            }
        }
        return ((ContentFacet)this.getRepository().facet(ContentFacet.class)).assets().path(NugetAssetUtils.assetName(context)).find().map(FluentAsset::download).orElse(null);
    }

    @Override
    @Guarded(by={"STARTED"})
    public Content put(Map<String, String> metadata, TempBlob tempBlob) {
        Preconditions.checkNotNull(metadata);
        Preconditions.checkNotNull((Object)tempBlob);
        String componentName = metadata.get("ID");
        String componentVersion = NugetDataUtils.checkVersion(NugetDataUtils.normalizeVersion(metadata));
        Map<String, String> componentMetadata = this.getComponentMetadata(metadata);
        return ((NugetContentFacet)this.facet(NugetContentFacet.class)).putPackage(componentName, componentVersion, tempBlob, componentMetadata, this.getAssetMetadata(metadata)).download();
    }

    @Override
    @Guarded(by={"STARTED"})
    public Content hardLinkPut(Map<String, String> metadata, Blob assetBlob, Map<HashAlgorithm, HashCode> checksums) {
        Preconditions.checkNotNull(metadata);
        Preconditions.checkNotNull((Object)assetBlob);
        String componentName = metadata.get("ID");
        String componentVersion = NugetDataUtils.checkVersion(NugetDataUtils.normalizeVersion(metadata));
        Map<String, String> componentMetadata = this.getComponentMetadata(metadata);
        Map<String, Object> assetMetadata = this.getAssetMetadata(metadata);
        return ((NugetContentFacet)this.facet(NugetContentFacet.class)).putHardlinkPackage(componentName, componentVersion, assetBlob, componentMetadata, assetMetadata, checksums).download();
    }

    private Optional<Content> findByNormalizedVersion(String packageId, String version) throws IOException {
        Optional<FluentComponent> binary = ((NugetContentFacet)this.facet(NugetContentFacet.class)).findComponents(packageId).stream().filter(component -> {
            String componentVersion = component.version();
            String componentNormalizedVersion = NugetDataUtils.buildNormalizeVersion(componentVersion).orElse(null);
            return version.equalsIgnoreCase(componentNormalizedVersion);
        }).findFirst();
        if (binary.isPresent()) {
            FluentComponent component2 = binary.get();
            return ((NugetContentFacet)this.getRepository().facet(NugetContentFacet.class)).get(component2.name(), component2.version());
        }
        return Optional.empty();
    }

    private Map<String, String> getComponentMetadata(Map<String, String> metadata) {
        String componentName = metadata.get("ID");
        String componentVersion = NugetDataUtils.checkVersion(NugetDataUtils.normalizeVersion(metadata));
        HashMap componentMetadata = Maps.newHashMap();
        componentMetadata.put("id", componentName);
        componentMetadata.put("package_hash", metadata.get("PACKAGEHASH"));
        componentMetadata.put("package_hash_algorithm", metadata.get("PACKAGEHASHALGORITHM"));
        componentMetadata.put("title", metadata.get("TITLE"));
        componentMetadata.put("version", componentVersion);
        String creationTime = ODataFeedUtils.datetime(DateTime.now().getMillis());
        componentMetadata.put("CREATED", creationTime);
        componentMetadata.put("LASTUPDATED", creationTime);
        componentMetadata.put("PUBLISHED", creationTime);
        return componentMetadata;
    }

    private Map<String, Object> getAssetMetadata(Map<String, String> metadata) {
        Preconditions.checkNotNull(metadata);
        HashMap<String, Object> nugetAttributes = new HashMap<String, Object>();
        String now = ODataFeedUtils.datetime(DateTime.now().getMillis());
        nugetAttributes.put("created", now);
        nugetAttributes.put("published", now);
        nugetAttributes.put("authors", metadata.get("AUTHORS"));
        nugetAttributes.put("copyright", metadata.get("COPYRIGHT"));
        nugetAttributes.put("dependencies", metadata.get("DEPENDENCIES"));
        nugetAttributes.put("description", metadata.get("DESCRIPTION"));
        nugetAttributes.put("gallery_details_url", metadata.get("GALLERYDETAILSURL"));
        nugetAttributes.put("icon_url", metadata.get("ICONURL"));
        nugetAttributes.put("id", metadata.get("ID"));
        nugetAttributes.put("is_prerelease", NugetDataUtils.isPrerelease(metadata));
        nugetAttributes.put("language", metadata.get("LANGUAGE"));
        nugetAttributes.put("license", metadata.get("LICENSE"));
        nugetAttributes.put("license_type", metadata.get("LICENSETYPE"));
        nugetAttributes.put("license_url", metadata.get("LICENSEURL"));
        nugetAttributes.put("location", metadata.get("LOCATION"));
        nugetAttributes.put("package_hash", metadata.get("PACKAGEHASH"));
        nugetAttributes.put("package_hash_algorithm", metadata.get("PACKAGEHASHALGORITHM"));
        nugetAttributes.put("package_size", Long.parseLong(metadata.get("PACKAGESIZE")));
        nugetAttributes.put("project_url", metadata.get("PROJECTURL"));
        nugetAttributes.put("release_notes", metadata.get("RELEASENOTES"));
        nugetAttributes.put("report_abuse_url", metadata.get("REPORTABUSEURL"));
        nugetAttributes.put("require_license_acceptance", Boolean.parseBoolean(metadata.get("REQUIRELICENSEACCEPTANCE")));
        nugetAttributes.put("summary", metadata.get("SUMMARY"));
        nugetAttributes.put("tags", metadata.get("TAGS"));
        nugetAttributes.put("title", metadata.get("TITLE"));
        nugetAttributes.put("version", NugetDataUtils.normalizeVersion(metadata));
        nugetAttributes.put("min_client_version", metadata.get("MINCLIENTVERSION"));
        nugetAttributes.put("last_updated", metadata.get("LASTUPDATED") == null ? now : metadata.get("LASTUPDATED"));
        NugetV2ODataUtils.updateDerivedTextFields(nugetAttributes);
        return nugetAttributes;
    }
}

