/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore;

import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.internal.NugetReplicationHelper;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.content.replication.ReplicationFacetSupport;
import org.sonatype.nexus.repository.content.replication.ReplicationIngestionService;

@Named(value="nuget")
public class NugetReplicationFacet
extends ReplicationFacetSupport {
    private final ReplicationIngestionService ingestionService;
    private final NugetReplicationHelper nugetReplicationHelper;

    @Inject
    public NugetReplicationFacet(ReplicationIngestionService ingestionService, NugetReplicationHelper nugetReplicationHelper) {
        this.ingestionService = Objects.requireNonNull(ingestionService);
        this.nugetReplicationHelper = Objects.requireNonNull(nugetReplicationHelper);
    }

    public void doReplicate(String path, Blob blob, Map<String, Object> assetAttributes, Map<String, Object> componentAttributes) {
        ContentFacet contentFacet = (ContentFacet)this.facet(ContentFacet.class);
        FluentAssets fluentAssets = contentFacet.assets();
        FluentComponents fluentComponents = contentFacet.components();
        if (NugetPackageUtils.isV3Metadata(path)) {
            this.ingestionService.replicateAsset(fluentAssets, path.replaceFirst("^/?", "/"), blob, assetAttributes, "");
        } else {
            NugetPackageCoords coords = this.nugetReplicationHelper.getMetadata(blob);
            String name = coords.getId();
            String version = coords.getVersion();
            FluentComponent component = this.ingestionService.replicateComponent(fluentComponents, componentAttributes, name, version);
            this.ingestionService.replicateAsset(fluentAssets, coords.toPath(), blob, assetAttributes, "", component);
        }
    }
}

