/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.api;

import com.sonatype.nexus.repository.nuget.NugetVersion;
import com.sonatype.nexus.repository.nuget.api.NugetAttributes;
import com.sonatype.nexus.repository.nuget.api.NugetProxyApiRepository;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.api.SimpleApiRepositoryAdapter;
import org.sonatype.nexus.repository.rest.api.model.AbstractApiRepository;
import org.sonatype.nexus.repository.rest.api.model.SimpleApiHostedRepository;
import org.sonatype.nexus.repository.rest.api.model.StorageAttributes;
import org.sonatype.nexus.repository.routing.RoutingRuleStore;

@Named(value="nuget")
public class NugetApiRepositoryAdapter
extends SimpleApiRepositoryAdapter {
    @Inject
    public NugetApiRepositoryAdapter(RoutingRuleStore routingRuleStore) {
        super(routingRuleStore);
    }

    public AbstractApiRepository adapt(Repository repository) {
        boolean online = repository.getConfiguration().isOnline();
        String name = repository.getName();
        String url = repository.getUrl();
        switch (repository.getType().toString()) {
            case "hosted": {
                return new SimpleApiHostedRepository(name, "nuget", url, Boolean.valueOf(online), this.getHostedStorageAttributes(repository), this.getCleanupPolicyAttributes(repository), this.getComponentAttributes(repository));
            }
            case "proxy": {
                return new NugetProxyApiRepository(name, url, online, (StorageAttributes)this.getHostedStorageAttributes(repository), this.getCleanupPolicyAttributes(repository), this.getProxyAttributes(repository), this.getNegativeCacheAttributes(repository), this.getHttpClientAttributes(repository), this.getRoutingRuleName(repository), this.createNugetAttributes(repository), this.getReplicationAttributes(repository));
            }
        }
        return super.adapt(repository);
    }

    private NugetAttributes createNugetAttributes(Repository repository) {
        Integer getQueryCacheItemMaxAge = NugetApiRepositoryAdapter.toInt((Number)((Number)repository.getConfiguration().attributes("nugetProxy").get("queryCacheItemMaxAge", Number.class)));
        String nugetVersion = NugetApiRepositoryAdapter.toString((Object)repository.getConfiguration().attributes("nugetProxy").get("nugetVersion"), (Object)NugetVersion.V3.toString());
        return new NugetAttributes(getQueryCacheItemMaxAge, NugetVersion.valueOf(nugetVersion));
    }
}

