/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.replication.PullReplicationSupport;

@Named(value="nuget")
@Singleton
public class NugetPullReplicationSupport
implements PullReplicationSupport {
    public String translatePath(Repository repository, String path) {
        if (this.isV3(repository)) {
            String[] parts = path.split("/");
            String packageId = parts[1];
            String version = parts[2];
            return String.format("/v3/content/%s/%s/%s.%s.nupkg", packageId, version, packageId, version);
        }
        return path;
    }

    private boolean isV3(Repository repository) {
        String nugetVersion = (String)repository.getConfiguration().attributes("nugetProxy").get("nugetVersion");
        return "V3".equals(nugetVersion);
    }
}

