/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.nuget.internal.orient;

import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import javax.annotation.Priority;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.restore.orient.DefaultOrientIntegrityCheckStrategy;
import org.sonatype.nexus.blobstore.restore.orient.OrientIntegrityCheckStrategy;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@FeatureFlag(name="nexus.orient.enabled")
@Priority(value=0x7FFFFFFF)
@Named(value="nuget")
@Singleton
public class NugetOrientIntegrityCheckStrategy
extends DefaultOrientIntegrityCheckStrategy
implements OrientIntegrityCheckStrategy {
    static final String BAD_FORMAT = "Asset name '%s' not in expected Nuget format of 'name/version'";

    protected String getAssetName(Asset asset) {
        String assetName = super.getAssetName(asset);
        return this.getFileName(assetName);
    }

    private String getFileName(String packageName) {
        if (NugetPackageUtils.isV3Metadata(packageName)) {
            return packageName;
        }
        int slashPos = packageName.lastIndexOf(47);
        if (slashPos == -1) {
            throw new IllegalArgumentException(String.format(BAD_FORMAT, packageName));
        }
        return String.valueOf(packageName.substring(0, slashPos)) + "-" + packageName.substring(slashPos + 1) + ".nupkg";
    }

    protected String getBlobName(BlobAttributes blobAttributes) {
        String blobName = blobAttributes.getProperties().getProperty("@BlobStore.blob-name");
        String blobType = blobAttributes.getProperties().getProperty("@BlobStore.content-type");
        if (NugetPackageUtils.isV3Package(blobType)) {
            return this.getFileName(blobName);
        }
        return blobName;
    }

    protected Iterable<Asset> getAssets(Repository repository) {
        return (Iterable)Transactional.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).call(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            return tx.browseAssets(Query.builder().where("blob_ref").isNotNull().build(), tx.findBucket(repository));
        });
    }
}

