/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.nuget.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.NugetPackageException;
import com.sonatype.nexus.repository.nuget.NugetVersion;
import com.sonatype.nexus.repository.nuget.datastore.ContentNugetV3HostedFacet;
import com.sonatype.nexus.repository.nuget.datastore.NugetContentFacet;
import com.sonatype.nexus.repository.nuget.datastore.internal.v2.NugetV2ProxyFacet;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import com.sonatype.nexus.repository.nuget.odata.ODataFeedUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections.MapUtils;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.restore.datastore.BaseRestoreBlobStrategy;
import org.sonatype.nexus.blobstore.restore.datastore.DataStoreRestoreBlobData;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.types.ProxyType;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.matchers.token.TokenParser;
import org.sonatype.nexus.repository.view.payloads.DetachedBlobPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@FeatureFlag(name="nexus.datastore.enabled")
@Named(value="nuget")
@Singleton
public class NugetRestoreBlobStrategy
extends BaseRestoreBlobStrategy<DataStoreRestoreBlobData> {
    private final RepositoryManager repositoryManager;
    private final Clock clock;

    @Inject
    public NugetRestoreBlobStrategy(DryRunPrefix dryRunPrefix, RepositoryManager repositoryManager, Clock clock) {
        super(dryRunPrefix);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.clock = clock;
    }

    protected boolean canAttemptRestore(@Nonnull DataStoreRestoreBlobData data) {
        Repository repository = data.getRepository();
        if (repository.optionalFacet(ContentFacet.class).isPresent()) {
            return true;
        }
        this.log.warn("Skipping as Content Facet not found on repository: {}", (Object)repository.getName());
        return false;
    }

    protected boolean isComponentRequired(DataStoreRestoreBlobData data) {
        return NugetPackageUtils.isV3Package(data.getBlobType()) || data.getBlobType().equals("application/zip");
    }

    private Optional<Map<String, String>> extractPackageMetadata(DataStoreRestoreBlobData data) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream inputStream = data.getBlob().getInputStream();){
                Map<String, String> metadata = NugetPackageUtils.packageMetadata(inputStream);
                NugetRestoreBlobStrategy.addCreationTime(this.clock.millis(), metadata);
                return Optional.of(metadata);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NugetPackageException | IOException exception) {
            return Optional.empty();
        }
    }

    private static void addCreationTime(long milliseconds, Map<String, String> metadata) {
        String timeStamp = ODataFeedUtils.datetime(milliseconds);
        metadata.put("CREATED", timeStamp);
        metadata.put("LASTUPDATED", timeStamp);
        metadata.put("PUBLISHED", timeStamp);
    }

    private void restoreV3Metadata(DataStoreRestoreBlobData data) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (DetachedBlobPayload payload = new DetachedBlobPayload(data.getBlob());){
            ((NugetContentFacet)data.getRepository().facet(NugetContentFacet.class)).putMetadata(data.getBlobName(), (Payload)payload);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void restoreV3ProxyPackage(DataStoreRestoreBlobData data) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (DetachedBlobPayload payload = new DetachedBlobPayload(data.getBlob());){
            NugetPackageCoords nugetCoords = this.getPackageIdAndVersionFromPath(data.getBlobName());
            ((NugetContentFacet)data.getRepository().facet(NugetContentFacet.class)).putPackage(nugetCoords.getId(), nugetCoords.getVersion(), (Payload)payload);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void restoreHostedPackage(DataStoreRestoreBlobData data) {
        Map metadata = this.extractPackageMetadata(data).orElse(null);
        if (MapUtils.isEmpty((Map)metadata)) {
            this.log.warn("Skipping invalid NuGet package blob. Unable to load metadata from {} for the repository {}.", (Object)data.getBlobName(), (Object)data.getRepository().getName());
            return;
        }
        ((NugetContentFacet)data.getRepository().facet(NugetContentFacet.class)).putV2Metadata(Collections.singletonList(metadata));
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = ((ContentFacet)data.getRepository().facet(ContentFacet.class)).blobs().ingest((Payload)new DetachedBlobPayload(data.getBlob()), NugetPackageUtils.HASH_ALGORITHMS);){
            ((ContentNugetV3HostedFacet)data.getRepository().facet(ContentNugetV3HostedFacet.class)).put(metadata, tempBlob);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void restoreV2ProxyPackage(DataStoreRestoreBlobData data) throws IOException {
        Map metadata = this.extractPackageMetadata(data).orElse(null);
        if (MapUtils.isEmpty((Map)metadata)) {
            this.log.warn("Skipping invalid NuGet package blob. Unable to load metadata from {} for the repository {}.", (Object)data.getBlobName(), (Object)data.getRepository().getName());
            return;
        }
        ((NugetContentFacet)data.getRepository().facet(NugetContentFacet.class)).putV2Metadata(Collections.singletonList(metadata));
        NugetPackageCoords nugetCoords = this.getPackageIdAndVersionFromPath(data.getBlobName());
        Throwable throwable = null;
        Object var5_6 = null;
        try (Content content = new Content((Payload)new DetachedBlobPayload(data.getBlob()));){
            ((NugetV2ProxyFacet)data.getRepository().facet(NugetV2ProxyFacet.class)).storePackage(nugetCoords, content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private NugetVersion getNugetVersion(Repository repository) {
        String nugetVersionAttribute = (String)repository.getConfiguration().attributes("nugetProxy").get("nugetVersion", String.class);
        if (NugetVersion.V3.name().equals(nugetVersionAttribute)) {
            return NugetVersion.V3;
        }
        return NugetVersion.V2;
    }

    protected void createAssetFromBlob(Blob assetBlob, DataStoreRestoreBlobData data) throws IOException {
        if (data.getBlobName().endsWith(".json")) {
            this.restoreV3Metadata(data);
        } else if (data.getRepository().getType() instanceof ProxyType) {
            NugetVersion nugetVersion = this.getNugetVersion(data.getRepository());
            if (nugetVersion == NugetVersion.V3) {
                this.restoreV3ProxyPackage(data);
            } else if (nugetVersion == NugetVersion.V2) {
                this.restoreV2ProxyPackage(data);
            }
        } else if (data.getRepository().getType() instanceof HostedType) {
            this.restoreHostedPackage(data);
        }
    }

    private NugetPackageCoords getPackageIdAndVersionFromPath(String path) {
        return this.getPackageIdAndVersion(path, "/{id}/{version}", "/{id}-{version}.nupkg");
    }

    private NugetPackageCoords getPackageIdAndVersion(String path, String ... parsers) {
        String[] stringArray = parsers;
        int n = parsers.length;
        int n2 = 0;
        while (n2 < n) {
            String parser = stringArray[n2];
            Map parsedPath = new TokenParser(parser).parse(path);
            if (parsedPath != null) {
                String id = (String)parsedPath.get("id");
                String version = (String)parsedPath.get("version");
                return new NugetPackageCoords(id, version);
            }
            ++n2;
        }
        throw new IllegalArgumentException(path);
    }

    protected DataStoreRestoreBlobData createRestoreData(Properties properties, Blob blob, BlobStore blobStore) {
        return new DataStoreRestoreBlobData(blob, properties, blobStore, this.repositoryManager);
    }

    protected String getAssetPath(@Nonnull DataStoreRestoreBlobData data) {
        return data.getBlobName();
    }

    public void after(boolean updateAssets, Repository repository) {
    }
}

