/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.nuget.internal;

import com.sonatype.nexus.repository.nuget.NugetPackageException;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.restore.datastore.DefaultIntegrityCheckStrategy;
import org.sonatype.nexus.blobstore.restore.datastore.IntegrityCheckStrategy;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;

@Named(value="nuget")
@Singleton
@FeatureFlag(name="nexus.datastore.enabled")
public class NugetIntegrityCheckStrategy
extends DefaultIntegrityCheckStrategy
implements IntegrityCheckStrategy {
    static final String BAD_FORMAT = "Asset name '%s' not in expected Nuget format of 'name/version'";
    final BlobStoreManager blobStoreManager;

    @Inject
    public NugetIntegrityCheckStrategy(BlobStoreManager blobStoreManager, @Named(value="${nexus.blobstore.restore.integrityCheck.batchSize:-1000}") @Named(value="${nexus.blobstore.restore.integrityCheck.batchSize:-1000}") int browseBatchSize) {
        super(browseBatchSize);
        this.blobStoreManager = blobStoreManager;
    }

    protected String getAssetName(Asset asset) {
        String assetPath = asset.path();
        if (NugetPackageUtils.isV3Metadata(assetPath)) {
            return assetPath;
        }
        String assetPathFromComponent = asset.component().map(component -> String.valueOf('/') + component.name() + '/' + component.version()).orElseThrow(() -> new RuntimeException("Component not found for asset " + asset.path()));
        if (!StringUtils.equalsIgnoreCase((CharSequence)assetPath, (CharSequence)assetPathFromComponent)) {
            throw new IllegalArgumentException(String.format(BAD_FORMAT, assetPath));
        }
        return assetPath;
    }

    protected String getBlobName(BlobAttributes blobAttributes, Asset asset) {
        String blobName = blobAttributes.getProperties().getProperty("@BlobStore.blob-name");
        if (blobName != null && blobName.endsWith(".nupkg")) {
            return this.loadOrientBlobName(blobName, asset);
        }
        return blobName;
    }

    private String loadOrientBlobName(String blobName, Asset asset) {
        this.log.debug("Blob has a name of {} will need to deduce coordinates", (Object)blobName);
        if (blobName.indexOf(45) == blobName.lastIndexOf(45)) {
            String properBlobName = blobName.replaceFirst("-", "/").replace(".nupkg", "");
            this.log.debug("Blob has a name that can be parsed for coordinates, using {}", (Object)properBlobName);
            return properBlobName;
        }
        if (asset.hasBlob()) {
            this.log.debug("Blob has a name {} that cannot be parsed for coordinates, will read the nupsec in package", (Object)blobName);
            return this.loadOrientBlobNameFromPackage(blobName, (AssetBlob)asset.blob().get());
        }
        String msg = String.format("Unable to derive nuget coordinates from %s and without a blob file", blobName);
        this.log.error(msg);
        throw new IllegalArgumentException(msg);
    }

    private String loadOrientBlobNameFromPackage(String blobName, AssetBlob assetBlob) {
        Blob blob = this.blobStoreManager.get(assetBlob.blobRef().getStore()).get(assetBlob.blobRef().getBlobId());
        if (blob != null) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStream is = blob.getInputStream();){
                    Map<String, String> metadataMap = NugetPackageUtils.packageMetadata(is);
                    if (metadataMap.containsKey("ID") && metadataMap.containsKey("VERSION")) {
                        String properBlobName = "/" + metadataMap.get("ID") + "/" + metadataMap.get("VERSION");
                        this.log.debug("Blob has a name {} that has been translated to {} by reading the package nuspec xml file", (Object)blobName, (Object)properBlobName);
                        return properBlobName;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (NugetPackageException | IOException e) {
                String msg = String.format("Failed to parse nuget package %s to retrieve coordinates", blobName);
                this.log.error(msg);
                throw new RuntimeException(msg, e);
            }
        }
        String msg = String.format("Could not retrieve coordinates from nuget package %s", blobName);
        this.log.error(msg);
        throw new IllegalArgumentException(msg);
    }
}

