/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.utils;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentBlobs;

@Deprecated
@Named
@Singleton
public class HardLinkHelper {
    private final MimeSupport mimeSupport;

    @Inject
    public HardLinkHelper(MimeSupport mimeSupport) {
        this.mimeSupport = (MimeSupport)Preconditions.checkNotNull((Object)mimeSupport);
    }

    public Blob ingestHardLink(Repository repository, File content, HashCode hashCodeSha1) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)content);
        Preconditions.checkNotNull((Object)hashCodeSha1);
        HashMap<String, String> headers = new HashMap<String, String>();
        String path = content.getPath();
        headers.put("BlobStore.blob-name", path);
        String contentType = this.detectMimeType(content);
        headers.put("BlobStore.content-type", contentType);
        Path contentPath = content.toPath();
        FluentBlobs fluentBlobs = ((ContentFacet)repository.facet(ContentFacet.class)).blobs();
        return fluentBlobs.ingest(contentPath, headers, hashCodeSha1, Files.size(contentPath));
    }

    public Blob ingestHardLink(Repository repository, File content, HashCode hashCodeSha1, String contentType) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)content);
        Preconditions.checkNotNull((Object)hashCodeSha1);
        Preconditions.checkNotNull((Object)contentType);
        HashMap<String, String> headers = new HashMap<String, String>();
        String path = content.getPath();
        headers.put("BlobStore.blob-name", path);
        headers.put("BlobStore.content-type", contentType);
        Path contentPath = content.toPath();
        FluentBlobs fluentBlobs = ((ContentFacet)repository.facet(ContentFacet.class)).blobs();
        return fluentBlobs.ingest(contentPath, headers, hashCodeSha1, Files.size(contentPath));
    }

    private String detectMimeType(File content) throws IOException {
        String path = content.getPath();
        Path contentPath = content.toPath();
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(contentPath, new OpenOption[0]));){
            return this.mimeSupport.detectMimeType((InputStream)inputStream, path);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

