/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.RepositoryContent;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAttributes;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;

public class FormatAttributesUtils {
    public static Map<String, Object> getFormatAttributes(FluentAsset fluent) {
        return FormatAttributesUtils.getFormatAttributes(fluent.repository().getFormat().getValue(), fluent);
    }

    public static Map<String, Object> getFormatAttributes(Asset asset, String formatName) {
        return FormatAttributesUtils.getFormatAttributes(formatName, asset);
    }

    public static Map<String, Object> getFormatAttributes(FluentComponent fluent) {
        return FormatAttributesUtils.getFormatAttributes(fluent.repository().getFormat().getValue(), fluent);
    }

    public static void setFormatAttributes(FluentAsset fluent, Map<String, Object> values) {
        FormatAttributesUtils.setFormatAttributes(fluent.repository().getFormat().getValue(), fluent, fluent, values);
    }

    public static void setFormatAttributes(FluentAsset fluent, Supplier<Map<String, Object>> supplier) {
        FormatAttributesUtils.setFormatAttributes(fluent, supplier.get());
    }

    public static void setFormatAttributes(FluentAsset fluent, String key, Object value) {
        FormatAttributesUtils.setFormatAttributes(fluent, Collections.singletonMap(key, value));
    }

    public static void setFormatAttributes(FluentComponent fluent, Map<String, Object> values) {
        FormatAttributesUtils.setFormatAttributes(fluent.repository().getFormat().getValue(), fluent, fluent, values);
    }

    public static void removeFormatAttributes(FluentComponent fluent, Set<String> keys) {
        FormatAttributesUtils.removeFormatAttributes(fluent.repository().getFormat().getValue(), fluent, fluent, keys);
    }

    public static void removeFormatAttributes(FluentAsset fluent, Set<String> keys) {
        FormatAttributesUtils.removeFormatAttributes(fluent.repository().getFormat().getValue(), fluent, fluent, keys);
    }

    public static void removeFormatAttributes(FluentComponent fluent, String key) {
        FormatAttributesUtils.removeFormatAttributes(fluent, Collections.singleton(key));
    }

    public static void removeFormatAttributes(FluentAsset fluent, String key) {
        FormatAttributesUtils.removeFormatAttributes(fluent, Collections.singleton(key));
    }

    private static Map<String, Object> getFormatAttributes(String formatName, RepositoryContent repositoryContent) {
        Map attributes = (Map)repositoryContent.attributes().get(formatName);
        if (attributes == null) {
            return new HashMap<String, Object>();
        }
        return new HashMap<String, Object>(attributes);
    }

    private static void setFormatAttributes(String formatName, RepositoryContent repositoryContent, FluentAttributes attributes, Map<String, Object> values) {
        Map<String, Object> formatAttributes = FormatAttributesUtils.getFormatAttributes(formatName, repositoryContent);
        formatAttributes.putAll(values);
        attributes.withAttribute(formatName, formatAttributes);
    }

    private static void removeFormatAttributes(String formatName, RepositoryContent repositoryContent, FluentAttributes attributes, Set<String> keys) {
        Map<String, Object> formatAttributes = FormatAttributesUtils.getFormatAttributes(formatName, repositoryContent);
        keys.forEach(key -> {
            Object v = formatAttributes.remove(key);
        });
        attributes.withAttribute(formatName, formatAttributes);
    }
}

