/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.upgrades;

import java.sql.Connection;
import java.sql.Statement;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

@Named
public class FormatSearchViewsMigrationStep_1_20
implements DatabaseMigrationStep {
    private static final String DROP_FORMAT_SEARCH_VIEW = "DROP VIEW IF EXISTS %s_component_search CASCADE";
    private final List<Format> formats;

    @Inject
    public FormatSearchViewsMigrationStep_1_20(List<Format> formats) {
        this.formats = formats;
    }

    public Optional<String> version() {
        return Optional.of("1.20");
    }

    public void migrate(Connection connection) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement st = connection.createStatement();){
            for (Format format : this.formats) {
                st.execute(String.format(DROP_FORMAT_SEARCH_VIEW, format.getValue()));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

