/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.upgrades;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

@Named
@Singleton
public class DatastoreBlobReconciliationLogMigrator_1_11
extends ComponentSupport
implements DatabaseMigrationStep {
    public static final String RECONCILIATION_DIRECTORY_NAME = "reconciliation";
    protected static final String BLOBSTORE = "blobstore";
    protected static final String BLOBSTORE_LOG_PATH = "log" + File.separator + "blobstore";
    protected static final String ATTRIBUTES = "attributes";
    protected static final String TABLE_NAME = "blob_store_configuration";
    private static final String QUERY = "SELECT * FROM %s WHERE name = ?";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final TypeReference<Map<String, Map<String, Object>>> ATTRIBUTES_TYPE_REF = new TypeReference<Map<String, Map<String, Object>>>(){};
    private final ApplicationDirectories applicationDirectories;

    @Inject
    public DatastoreBlobReconciliationLogMigrator_1_11(ApplicationDirectories applicationDirectories) {
        this.applicationDirectories = (ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories);
    }

    public Optional<String> version() {
        return Optional.of("1.11");
    }

    public void migrate(Connection connection) throws Exception {
        if (!this.tableExists(connection, TABLE_NAME)) {
            this.log.info("Table {} does not exist. Skipping upgrade step.", (Object)TABLE_NAME);
            return;
        }
        File reconciliationLogsBaseDirectory = this.applicationDirectories.getWorkDirectory(BLOBSTORE_LOG_PATH);
        Optional.ofNullable(reconciliationLogsBaseDirectory).map(File::listFiles).ifPresent(blobStoreReconciliationLogDirs -> this.copyFiles((File[])blobStoreReconciliationLogDirs, connection));
        Optional.ofNullable(reconciliationLogsBaseDirectory).ifPresent(this::deleteDirectory);
    }

    private void deleteDirectory(File reconciliationLogsBaseDirectory) {
        try {
            FileUtils.deleteDirectory((File)reconciliationLogsBaseDirectory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void copyFiles(File[] blobStoreReconciliationLogDirs, Connection connection) {
        this.log.info("Found reconciliation logs for {} blob stores to migrate", (Object)blobStoreReconciliationLogDirs.length);
        File[] fileArray = blobStoreReconciliationLogDirs;
        int n = blobStoreReconciliationLogDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File reconciliationLogDirectory = fileArray[n2];
            String blobStoreName = reconciliationLogDirectory.getName();
            this.getBlobStorePath(blobStoreName, connection).map(this::toAbsoluteBlobStorePath).ifPresent(blobStorePath -> this.copyDirectoryContentsToBlobstore(reconciliationLogDirectory, (Path)blobStorePath));
            ++n2;
        }
    }

    private void copyDirectoryContentsToBlobstore(File sourceDir, Path blobStorePath) {
        try {
            Path destination = blobStorePath.resolve(RECONCILIATION_DIRECTORY_NAME);
            List logFiles = Optional.ofNullable(sourceDir.listFiles()).map(fileArray -> Arrays.asList(fileArray)).orElse(Collections.emptyList());
            this.log.info("Copying reconciliation logs from {} to {}", (Object)sourceDir, (Object)destination);
            FileUtils.copyToDirectory(logFiles, (File)destination.toFile());
            this.log.info("Copied reconciliation logs from {} to {}", (Object)sourceDir, (Object)destination);
            FileUtils.deleteDirectory((File)sourceDir);
        }
        catch (IOException e) {
            this.log.warn("Skipping copy of reconciliation logs contained in {} because of error {}", (Object)sourceDir, (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }

    private Optional<Path> getBlobStorePath(String blobStoreName, Connection connection) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (PreparedStatement statement = connection.prepareStatement(String.format(QUERY, TABLE_NAME));){
                statement.setString(1, blobStoreName);
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    String attributeString = resultSet.getString(ATTRIBUTES);
                    this.log.info("attributes {}", (Object)attributeString);
                    Map nestedAttributesMap = (Map)MAPPER.readValue(attributeString, ATTRIBUTES_TYPE_REF);
                    return Optional.of(Paths.get(((Map)nestedAttributesMap.get("file")).get("path").toString(), new String[0]));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
        return Optional.empty();
    }

    private Path toAbsoluteBlobStorePath(Path configurationPath) {
        if (configurationPath.isAbsolute()) {
            return configurationPath;
        }
        Path baseDir = this.applicationDirectories.getWorkDirectory("blobs").toPath();
        try {
            Path normalizedBase = baseDir.toRealPath(new LinkOption[0]).normalize();
            return normalizedBase.resolve(configurationPath.normalize());
        }
        catch (IOException iOException) {
            this.log.error("Error converting {} to absolute path.", (Object)baseDir);
            return null;
        }
    }
}

