/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.upgrades;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.content.kv.global.GlobalKeyValueStore;
import org.sonatype.nexus.repository.content.kv.global.NexusKeyValue;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.UpgradeTaskScheduler;
import org.sonatype.nexus.upgrade.datastore.RepeatableDatabaseMigrationStep;

@Named
public class ComponentNormalizedVersionMigrationStep
extends RepeatableDatabaseMigrationStep {
    private final String TABLE_NAME = "{format}_component";
    private final String COLUMN_NAME = "normalized_version";
    private final String INDEX_NAME = "idx_{format}_normalized_version";
    private final String ADD_COLUMN_STATEMENT = String.format("ALTER TABLE %s ADD COLUMN IF NOT EXISTS %s VARCHAR;", "{format}_component", "normalized_version");
    private final String ADD_INDEX_STATEMENT = String.format("CREATE INDEX IF NOT EXISTS %s ON  %s (%s)", "idx_{format}_normalized_version", "{format}_component", "normalized_version");
    private final List<Format> formats;
    private final GlobalKeyValueStore globalKeyValueStore;
    private final TaskScheduler taskScheduler;
    private final UpgradeTaskScheduler startupScheduler;

    @Inject
    public ComponentNormalizedVersionMigrationStep(List<Format> formats, GlobalKeyValueStore globalKeyValueStore, TaskScheduler taskScheduler, UpgradeTaskScheduler startupScheduler) {
        this.formats = formats;
        this.globalKeyValueStore = globalKeyValueStore;
        this.taskScheduler = taskScheduler;
        this.startupScheduler = startupScheduler;
    }

    public Integer getChecksum() {
        return Objects.hash(this.formats.stream().map(Format::getValue).sorted().toArray());
    }

    public void migrate(Connection connection) throws Exception {
        this.alterFormats(connection);
        this.scheduleTask();
    }

    private void scheduleTask() {
        this.startupScheduler.schedule(this.taskScheduler.createTaskConfigurationInstance("component.normalize.version"));
    }

    private void alterFormats(Connection connection) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement alterStmt = connection.createStatement();){
            for (Format format : this.formats) {
                if (this.isFormatNormalized(format)) continue;
                this.alter(connection, alterStmt, format);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void alter(Connection connection, Statement alterStatement, Format format) throws SQLException {
        String formatName = format.getValue();
        this.log.info("validating {} component table", (Object)formatName);
        String tableName = ComponentNormalizedVersionMigrationStep.replace("{format}_component", formatName);
        if (!this.tableExists(connection, tableName)) {
            this.log.debug("{} component table not found", (Object)formatName);
            return;
        }
        if (!this.columnExists(connection, tableName, "normalized_version")) {
            this.log.info("adding missing column '{}' to {} format", (Object)"normalized_version", (Object)formatName);
            alterStatement.execute(ComponentNormalizedVersionMigrationStep.replace(this.ADD_COLUMN_STATEMENT, formatName));
            if (!this.indexExists(connection, ComponentNormalizedVersionMigrationStep.replace("idx_{format}_normalized_version", formatName))) {
                this.log.info("adding missing index '{}' to {} format", (Object)ComponentNormalizedVersionMigrationStep.replace("idx_{format}_normalized_version", formatName), (Object)formatName);
                alterStatement.execute(ComponentNormalizedVersionMigrationStep.replace(this.ADD_INDEX_STATEMENT, formatName));
            }
        }
    }

    private boolean isFormatNormalized(Format format) {
        return this.globalKeyValueStore.getKey(String.format("%s.normalized.version.available", format.getValue())).map(NexusKeyValue::getAsBoolean).orElse(false);
    }

    private static String replace(String query, String format) {
        return query.replaceAll("\\{format\\}", format);
    }
}

