/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.upgrades;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.UpgradeTaskScheduler;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

@Named
public class BrowseNodeMigrationStep_1_36
extends ComponentSupport
implements DatabaseMigrationStep {
    private static final String ASSET = "asset";
    private static final String COMPONENT = "component";
    private static final String SELECT = "SELECT DISTINCT B.repository_id, A.repository_id FROM %s_browse_node B, %s_%s A WHERE B.repository_id <> A.repository_id AND A.%s_id = B.%s_id";
    private static final String SELECT_REPOSITORY_NAME = "SELECT R.name FROM repository R, %s_content_repository C WHERE R.id = C.config_repository_id AND C.repository_id = ?";
    private static final String SELECT_PYPI_GROUP = "SELECT name FROM repository WHERE recipe_name = 'pypi-group'";
    private final List<Format> formats;
    private final TaskScheduler taskScheduler;
    private final UpgradeTaskScheduler upgradeTaskScheduler;

    @Inject
    public BrowseNodeMigrationStep_1_36(List<Format> formats, TaskScheduler ts, UpgradeTaskScheduler uts) {
        this.formats = (List)Preconditions.checkNotNull(formats);
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)ts);
        this.upgradeTaskScheduler = (UpgradeTaskScheduler)Preconditions.checkNotNull((Object)uts);
    }

    public Optional<String> version() {
        return Optional.of("1.36");
    }

    public void migrate(Connection connection) throws Exception {
        String names = this.formats.stream().flatMap(format -> this.migrateFormat(connection, (Format)format)).collect(Collectors.joining(","));
        if (!names.isEmpty()) {
            this.scheduleRebuildBrowseNodesTask(names);
        } else {
            this.log.debug("Found no repositories requiring rebuild");
        }
    }

    private Stream<String> migrateFormat(Connection connection, Format format) {
        String formatName = format.getValue();
        LinkedHashSet<Integer> repositoryIds = new LinkedHashSet<Integer>();
        this.executeStatement(repositoryIds, connection, formatName, ASSET);
        this.executeStatement(repositoryIds, connection, formatName, COMPONENT);
        return this.repositoryIdToName(connection, formatName, repositoryIds);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeStatement(Set<Integer> repositoryIds, Connection connection, String formatName, String type) {
        String query = String.format(SELECT, formatName, formatName, type, type, type);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try {
                PreparedStatement select = connection.prepareStatement(query);
                try {
                    try (ResultSet results = select.executeQuery();){
                        while (results.next()) {
                            repositoryIds.add(results.getInt(1));
                            repositoryIds.add(results.getInt(2));
                        }
                    }
                    if (select == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (select == null) throw throwable;
                    select.close();
                    throw throwable;
                }
                select.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            this.log.error("Failed to identify browse node tables with repository missmatches ('{}')", (Object)query, (Object)e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Stream<String> repositoryIdToName(Connection connection, String formatName, Set<Integer> repositoryIds) {
        LinkedHashSet<String> repositoryNames = new LinkedHashSet<String>();
        for (Integer n : repositoryIds) {
            try {
                Throwable throwable = null;
                Object var8_19 = null;
                try (PreparedStatement select = connection.prepareStatement(String.format(SELECT_REPOSITORY_NAME, formatName));){
                    select.setInt(1, n);
                    Throwable throwable2 = null;
                    Object var11_24 = null;
                    try {
                        ResultSet results;
                        block35: {
                            results = select.executeQuery();
                            if (results.next()) break block35;
                            this.log.warn("Unable to locate repository associated with {} id {}", (Object)formatName, (Object)n);
                            if (results == null) continue;
                            results.close();
                            continue;
                        }
                        try {
                            repositoryNames.add(results.getString(1));
                        }
                        finally {
                            if (results != null) {
                                results.close();
                            }
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                            throw throwable2;
                        }
                        if (throwable2 == throwable4) throw throwable2;
                        throwable2.addSuppressed(throwable4);
                        throw throwable2;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                        throw throwable;
                    }
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                    throw throwable;
                }
            }
            catch (SQLException e) {
                this.log.error("Failed to locate repositories for {}", (Object)formatName, (Object)e);
            }
        }
        if (!"pypi".equals(formatName)) return repositoryNames.stream();
        try {
            Throwable throwable = null;
            Iterator<Integer> iterator = null;
            try {
                PreparedStatement select = connection.prepareStatement(SELECT_PYPI_GROUP);
                try {
                    try (ResultSet results = select.executeQuery();){
                        while (results.next()) {
                            repositoryNames.add(results.getString(1));
                        }
                    }
                    if (select == null) return repositoryNames.stream();
                }
                catch (Throwable throwable6) {
                    void var5_12;
                    if (throwable == null) {
                        Throwable throwable7 = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    if (select == null) throw var5_12;
                    select.close();
                    throw var5_12;
                }
                select.close();
                return repositoryNames.stream();
            }
            catch (Throwable throwable8) {
                void var5_14;
                if (throwable == null) {
                    Throwable throwable9 = throwable8;
                    throw var5_14;
                }
                if (throwable == throwable8) throw var5_14;
                throwable.addSuppressed(throwable8);
                throw var5_14;
            }
        }
        catch (SQLException sQLException) {
            this.log.error("Failed to identify pypi-group repositories", (Throwable)sQLException);
        }
        return repositoryNames.stream();
    }

    private void scheduleRebuildBrowseNodesTask(String repositories) {
        TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("create.browse.nodes");
        configuration.setString("repositoryName", repositories);
        this.upgradeTaskScheduler.schedule(configuration);
        this.log.info("Scheduled post-startup task to rebuild browse nodes for repositories: {}", (Object)repositories);
    }
}

