/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.upgrades;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

@Named
public class BrowseNodeMigrationStep_1_34
extends ComponentSupport
implements DatabaseMigrationStep {
    private final List<Format> formats;
    private static final String DROP_INDEX = "DROP INDEX IF EXISTS idx_%s_browse_node_tree";
    private static final String CREATE_ASSET_INDEX = "CREATE INDEX IF NOT EXISTS idx_%s_browse_node_asset_id ON %s_browse_node (asset_id);";

    @Inject
    public BrowseNodeMigrationStep_1_34(List<Format> formats) {
        this.formats = formats;
    }

    public Optional<String> version() {
        return Optional.of("1.34");
    }

    public void migrate(Connection connection) throws Exception {
        this.formats.forEach(format -> this.migrateFormat(connection, (Format)format));
    }

    private void migrateFormat(Connection connection, Format format) {
        String formatName = format.getValue();
        this.executeStatement(connection, String.format(DROP_INDEX, formatName));
        this.executeStatement(connection, String.format(CREATE_ASSET_INDEX, formatName, formatName));
    }

    private void executeStatement(Connection connection, String sqlStatement) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (PreparedStatement select = connection.prepareStatement(sqlStatement);){
                select.executeUpdate();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            this.log.error("Failed to apply browse_node index change ('{}')", (Object)sqlStatement, (Object)e);
            throw new RuntimeException(e);
        }
    }
}

