/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.upgrades;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

@Named
public class BrowseNodeMigrationStep_1_33
extends ComponentSupport
implements DatabaseMigrationStep {
    private final List<Format> formats;
    private static final String ALTER_NODE_ID = "ALTER TABLE %s_browse_node ALTER COLUMN node_id SET DATA TYPE BIGINT;";
    private static final String ALTER_PARENT_ID = "ALTER TABLE %s_browse_node ALTER COLUMN parent_id SET DATA TYPE BIGINT;";

    @Inject
    public BrowseNodeMigrationStep_1_33(List<Format> formats) {
        this.formats = formats;
    }

    public Optional<String> version() {
        return Optional.of("1.33");
    }

    public void migrate(Connection connection) throws Exception {
        this.formats.forEach(format -> this.migrateFormat(connection, (Format)format));
    }

    private void migrateFormat(Connection connection, Format format) {
        try {
            PreparedStatement select;
            String formatName = format.getValue();
            Throwable throwable = null;
            Object var5_8 = null;
            try {
                select = connection.prepareStatement(String.format(ALTER_NODE_ID, formatName));
                try {
                    select.executeUpdate();
                }
                finally {
                    if (select != null) {
                        select.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var5_8 = null;
            try {
                select = connection.prepareStatement(String.format(ALTER_PARENT_ID, formatName));
                try {
                    select.executeUpdate();
                }
                finally {
                    if (select != null) {
                        select.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to apply browse_node id/parent datatype changes", e);
        }
    }
}

