/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.upgrades;

import java.sql.Connection;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

@Named
public class AssetBlobMigrationStep_1_21
implements DatabaseMigrationStep {
    private static final String DROP_INDEX = "DROP INDEX IF EXISTS idx_%s_asset_blob_blob_created";
    private final List<Format> formats;

    @Inject
    public AssetBlobMigrationStep_1_21(List<Format> formats) {
        this.formats = Objects.requireNonNull(formats);
    }

    public Optional<String> version() {
        return Optional.of("1.21");
    }

    public void migrate(Connection connection) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement st = connection.createStatement();){
            for (Format format : this.formats) {
                st.execute(String.format(DROP_INDEX, format.getValue()));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

