/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.tasks.normalize;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.logging.task.TaskLogType;
import org.sonatype.nexus.logging.task.TaskLogging;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.kv.global.GlobalKeyValueStore;
import org.sonatype.nexus.repository.content.kv.global.NexusKeyValue;
import org.sonatype.nexus.repository.content.kv.global.ValueType;
import org.sonatype.nexus.repository.content.store.ComponentData;
import org.sonatype.nexus.repository.content.store.ComponentStore;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.content.tasks.normalize.FormatVersionNormalizedEvent;
import org.sonatype.nexus.repository.content.tasks.normalize.NormalizationPriorityService;
import org.sonatype.nexus.repository.search.normalize.VersionNormalizerService;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskInterruptedException;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
@TaskLogging(value=TaskLogType.TASK_LOG_ONLY_WITH_PROGRESS)
public class NormalizeComponentVersionTask
extends TaskSupport
implements Cancelable {
    public static final String KEY_FORMAT = "%s.normalized.version.available";
    private final NormalizationPriorityService normalizationPriorityService;
    private final VersionNormalizerService versionNormalizerService;
    private final GlobalKeyValueStore globalKeyValueStore;
    private final EventManager eventManager;
    private ProgressLogIntervalHelper progressLogger;
    private final boolean disableTask;

    @Inject
    public NormalizeComponentVersionTask(NormalizationPriorityService normalizationPriorityService, VersionNormalizerService versionNormalizerService, GlobalKeyValueStore globalKeyValueStore, EventManager eventManager, @Named(value="${nexus.cleanup.disableNormalizeVersionTask:-false}") @Named(value="${nexus.cleanup.disableNormalizeVersionTask:-false}") boolean disableTask) {
        this.normalizationPriorityService = normalizationPriorityService;
        this.versionNormalizerService = versionNormalizerService;
        this.globalKeyValueStore = globalKeyValueStore;
        this.eventManager = eventManager;
        this.disableTask = disableTask;
    }

    public String getMessage() {
        return "populate normalized_version column on {format}_component tables";
    }

    protected Object execute() throws Exception {
        if (this.disableTask) {
            throw new TaskInterruptedException("The normalize version task was disabled", this.disableTask);
        }
        this.progressLogger = new ProgressLogIntervalHelper(this.log, 10);
        Map<Format, FormatStoreManager> formats = this.normalizationPriorityService.getPrioritizedFormats();
        int totalCount = formats.size();
        AtomicInteger skippedCount = new AtomicInteger();
        AtomicInteger processedCount = new AtomicInteger();
        formats.forEach((format, manager) -> this.processFormat(totalCount, skippedCount, processedCount, (Format)format, (FormatStoreManager)manager));
        return null;
    }

    private void processFormat(int totalCount, AtomicInteger skippedCount, AtomicInteger processedCount, Format format, FormatStoreManager manager) {
        this.log.info("normalizing {} components version", (Object)format.getValue());
        Object componentStore = manager.componentStore("nexus");
        if (!this.isFormatNormalized(format).booleanValue()) {
            this.setNormalizationState(format, false);
            this.normalizeFormat(format, (ComponentStore<?>)((Object)componentStore));
            this.setNormalizationState(format, true);
            this.eventManager.post((Object)new FormatVersionNormalizedEvent(format));
            int currentCount = processedCount.incrementAndGet();
            this.progressLogger.info(" task progress : {}% ({} of {} formats - skipped : {}) - elapsed : {}", new Object[]{Math.round((float)currentCount / (float)totalCount * 100.0f), currentCount, totalCount, skippedCount.get(), this.progressLogger.getElapsed()});
        } else {
            this.log.debug("skipping {} format since is already normalized.", (Object)format.getValue());
            skippedCount.getAndIncrement();
        }
    }

    private Boolean isFormatNormalized(Format format) {
        return this.globalKeyValueStore.getKey(this.getFormatKey(format)).map(NexusKeyValue::getAsBoolean).orElseGet(() -> {
            this.log.debug("no previous normalization state for {} format", (Object)format);
            return false;
        });
    }

    private void setNormalizationState(Format format, boolean value) {
        NexusKeyValue kv = new NexusKeyValue();
        kv.setKey(this.getFormatKey(format));
        kv.setType(ValueType.BOOLEAN);
        kv.setValue(value);
        this.globalKeyValueStore.setKey(kv);
    }

    private String getFormatKey(Format format) {
        return String.format(KEY_FORMAT, format.getValue());
    }

    private void normalizeFormat(Format format, ComponentStore<?> componentStore) {
        Continuation<ComponentData> page = componentStore.browseUnnormalized(Continuations.BROWSE_LIMIT, null);
        int totalCount = componentStore.countUnnormalized();
        int processedCount = 0;
        this.log.info("found {} unnormalized records on {} components", (Object)totalCount, (Object)format.getValue());
        while (!page.isEmpty() && page.nextContinuationToken() != null) {
            page.forEach(component -> {
                String normalizedVersion = this.versionNormalizerService.getNormalizedVersionByFormat(component.version(), format);
                component.setNormalizedVersion(normalizedVersion);
                componentStore.updateComponentNormalizedVersion((Component)component);
            });
            page = componentStore.browseUnnormalized(Continuations.BROWSE_LIMIT, page.nextContinuationToken());
            this.log.info(" {} format progress : {}% ({} of {}) - elapsed : {}", new Object[]{format.getValue(), Math.round((float)(processedCount += page.size()) / (float)totalCount * 100.0f), processedCount, totalCount, this.progressLogger.getElapsed()});
        }
    }
}

