/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.tasks;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.store.AssetBlobStore;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.scheduling.TaskInterruptedException;

public abstract class GenerateChecksumTaskSupport
extends RepositoryTaskSupport
implements Cancelable {
    private static final int ASSET_BROWSE_LIMIT = 100;
    private int bufferSize;
    private BlobStoreManager blobStoreManager;
    private MessageDigest messageDigest;

    @Inject
    public void init(@Named(value="${nexus.calculateChecksums.bufferSize:-32768}") @Named(value="${nexus.calculateChecksums.bufferSize:-32768}") int bufferSize, BlobStoreManager blobStoreManager) throws NoSuchAlgorithmException {
        this.bufferSize = Math.max(4096, bufferSize);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.messageDigest = MessageDigest.getInstance(HashAlgorithm.SHA256.name());
    }

    private BlobStore getBlobStore(Repository repository) {
        String name = (String)repository.getConfiguration().attributes("storage").get("blobStoreName", String.class);
        return this.blobStoreManager.get(name);
    }

    protected void execute(Repository repository) {
        this.log.info("Checking for missing SHA256 checksums in repository: {}", (Object)repository.getName());
        ContentFacetSupport contentFacet = (ContentFacetSupport)repository.facet(ContentFacet.class);
        BlobStore blobStore = this.getBlobStore(repository);
        AssetBlobStore<?> assetBlobStore = contentFacet.stores().assetBlobStore;
        Continuation assets = contentFacet.assets().browse(100, null);
        ResultCount resultCount = new ResultCount();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (ProgressLogIntervalHelper progressLogger = new ProgressLogIntervalHelper(this.log, 60);){
                while (!this.isCanceled() && !assets.isEmpty()) {
                    assets.forEach(asset -> this.processAssetChecksums(blobStore, assetBlobStore, (FluentAsset)asset, resultCount, progressLogger));
                    assets = contentFacet.assets().browse(100, assets.nextContinuationToken());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (TaskInterruptedException ex) {
            this.log.warn("Task interrupted. Processed {} assets. {} updated, {} skipped, {} errors.", new Object[]{resultCount.total, resultCount.updated, resultCount.skipped, resultCount.error});
            throw ex;
        }
        this.log.info("Completed processing a total of {} assets. {} updated, {} skipped, {} errors.", new Object[]{resultCount.total, resultCount.updated, resultCount.skipped, resultCount.error});
    }

    private void processAssetChecksums(BlobStore blobStore, AssetBlobStore<?> assetBlobStore, FluentAsset asset, ResultCount resultCount, ProgressLogIntervalHelper progressLogger) {
        CancelableHelper.checkCancellation();
        String assetPath = asset.path();
        this.log.debug("Checking asset: {}", (Object)assetPath);
        AssetBlob assetBlob = asset.blob().orElse(null);
        if (assetBlob != null) {
            Map<String, String> checksums = assetBlob.checksums();
            if (!checksums.containsKey(HashAlgorithm.SHA256.name())) {
                BlobId blobId = assetBlob.blobRef().getBlobId();
                Blob blob = blobStore.get(blobId);
                if (blob != null) {
                    String sha256 = this.calculateBlobChecksum(blob, assetPath);
                    if (sha256 != null) {
                        checksums.put(HashAlgorithm.SHA256.name(), sha256);
                        this.log.debug("Updating blob SHA256 checksum for asset: {}, blobID: {}, checksum: {}", new Object[]{assetPath, blobId, sha256});
                        assetBlobStore.setChecksums(assetBlob, checksums);
                        ++resultCount.updated;
                    } else {
                        this.log.debug("Unable to create SHA256 checksum for asset: {}, blobID: {}", (Object)assetPath, (Object)blobId);
                        ++resultCount.error;
                    }
                } else {
                    this.log.debug("No Blob associated with asset: {}. Skipping", (Object)assetPath);
                    ++resultCount.skipped;
                }
            }
        } else {
            this.log.debug("SHA256 checksum already present for asset: {}. Skipping", (Object)assetPath);
            ++resultCount.skipped;
        }
        ++resultCount.total;
        progressLogger.info("Elapsed time: {}. Processed {} assets. {} updated, {} skipped, {} errors.", new Object[]{progressLogger.getElapsed(), resultCount.total, resultCount.updated, resultCount.skipped, resultCount.error});
    }

    private String calculateBlobChecksum(Blob blob, String assetPath) {
        this.log.debug("Calculating SHA256 checksum for {}", (Object)assetPath);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inputStream = blob.getInputStream();){
                int bytesRead = 0;
                byte[] buffer = new byte[this.bufferSize];
                while (bytesRead != -1) {
                    bytesRead = inputStream.read(buffer);
                    if (bytesRead <= 0) continue;
                    this.messageDigest.update(buffer, 0, bytesRead);
                }
                return HashCode.fromBytes((byte[])this.messageDigest.digest()).toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.warn(String.format("Exception whilst calculating SHA256 checksum for %s: %s", assetPath, e.getLocalizedMessage()), (Throwable)(this.log.isDebugEnabled() ? e : null));
            return null;
        }
    }

    public String getMessage() {
        return "Generating sha256 hashes";
    }

    private static class ResultCount {
        int updated;
        int skipped;
        int error;
        int total;

        private ResultCount() {
        }
    }
}

