/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store.internal.migration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.content.store.AssetBlobStore;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Now;
import org.sonatype.nexus.scheduling.schedule.Schedule;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class AssetBlobRefMigrationTaskManager
extends LifecycleSupport
implements EventAware,
EventAware.Asynchronous {
    private final RepositoryManager repositoryManager;
    private final Map<String, FormatStoreManager> formatStoreManagers;
    private final TaskScheduler taskScheduler;

    @Inject
    public AssetBlobRefMigrationTaskManager(RepositoryManager repositoryManager, Map<String, FormatStoreManager> formatStoreManagers, TaskScheduler taskScheduler) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.formatStoreManagers = (Map)Preconditions.checkNotNull(formatStoreManagers);
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
    }

    protected void doStart() throws Exception {
        this.browseActiveFormatStores().forEach((format, contentStore) -> {
            Object assetBlobStore;
            boolean notMigratedAssetBlobRefsExists;
            FormatStoreManager formatStoreManager = this.formatStoreManagers.get(format);
            if (formatStoreManager != null && (notMigratedAssetBlobRefsExists = ((AssetBlobStore)((Object)((Object)(assetBlobStore = formatStoreManager.assetBlobStore((String)contentStore))))).notMigratedAssetBlobRefsExists())) {
                this.log.info("Found asset blobs with legacy blobRef for {} in {}. Scheduling a migration task for it.", format, contentStore);
                this.scheduleMigrationTask((String)format, (String)contentStore);
            }
        });
    }

    private Map<String, String> browseActiveFormatStores() {
        HashMap<String, String> activeFormatStores = new HashMap<String, String>();
        this.repositoryManager.browse().forEach(repository -> {
            Configuration configuration = repository.getConfiguration();
            NestedAttributesMap storageAttributes = configuration.attributes("storage");
            String format = repository.getFormat().getValue();
            String contentStore = (String)storageAttributes.get("dataStoreName");
            activeFormatStores.put(format, contentStore);
        });
        return activeFormatStores;
    }

    private void scheduleMigrationTask(String format, String contentStore) {
        ImmutableMap settings = ImmutableMap.of((Object)"format", (Object)format, (Object)"contentStore", (Object)contentStore);
        if (this.taskScheduler.getTaskByTypeId("assetBlob.blobRef.migration", (Map)settings) == null) {
            TaskConfiguration taskConfiguration = this.taskScheduler.createTaskConfigurationInstance("assetBlob.blobRef.migration");
            taskConfiguration.setName("Migrate blobRef assets field for " + format + " format");
            taskConfiguration.setString("format", format);
            taskConfiguration.setString("contentStore", contentStore);
            Now schedule = this.taskScheduler.getScheduleFactory().now();
            this.log.info("Scheduling blobRef migration task for {} format on {}", (Object)format, (Object)contentStore);
            this.taskScheduler.scheduleTask(taskConfiguration, (Schedule)schedule);
        }
    }
}

