/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store.internal.migration;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.datastore.api.DuplicateKeyException;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.store.AssetBlobData;
import org.sonatype.nexus.repository.content.store.AssetBlobStore;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
public class AssetBlobRefMigrationTask
extends TaskSupport
implements Cancelable {
    private final Map<String, FormatStoreManager> formatStoreManagers;
    private final int readAssetsBatchSize;

    @Inject
    public AssetBlobRefMigrationTask(Map<String, FormatStoreManager> formatStoreManagers, @Named(value="${nexus.assetBlobRef.migration.read.batchSize:-100}") @Named(value="${nexus.assetBlobRef.migration.read.batchSize:-100}") int readAssetsBatchSize) {
        this.formatStoreManagers = (Map)Preconditions.checkNotNull(formatStoreManagers);
        Preconditions.checkArgument((readAssetsBatchSize >= 0 ? 1 : 0) != 0, (Object)"Must use a non-negative readAssetsBatchSize");
        this.readAssetsBatchSize = readAssetsBatchSize;
    }

    protected Void execute() throws Exception {
        String format = this.getConfiguration().getString("format");
        String contentStore = this.getConfiguration().getString("contentStore");
        FormatStoreManager formatStoreManager = this.formatStoreManagers.get(format);
        if (formatStoreManager != null) {
            Object assetBlobStore = formatStoreManager.assetBlobStore(contentStore);
            int updatedCount = this.migrate((AssetBlobStore<?>)((Object)assetBlobStore), format);
            if (updatedCount > 0) {
                this.log.info("Updated {} {} blobs with new blob ref fields from {}", new Object[]{updatedCount, format, contentStore});
            }
        } else {
            this.log.warn("Unknown format {}", (Object)format);
        }
        return null;
    }

    private int migrate(AssetBlobStore<?> assetBlobStore, String format) {
        CancelableHelper.checkCancellation();
        int updateCount = 0;
        Continuation<AssetBlob> assetBlobs = assetBlobStore.browseAssetsWithLegacyBlobRef(this.readAssetsBatchSize, null);
        while (!this.isCanceled() && !assetBlobs.isEmpty()) {
            int migratedAssetsCount = this.migrateAssetBlobs(assetBlobStore, format, (Collection<AssetBlob>)assetBlobs);
            updateCount += migratedAssetsCount;
            assetBlobs = assetBlobStore.browseAssetsWithLegacyBlobRef(this.readAssetsBatchSize, assetBlobs.nextContinuationToken());
        }
        return updateCount;
    }

    private int migrateAssetBlobs(AssetBlobStore<?> assetBlobStore, String format, Collection<AssetBlob> assetBlobs) {
        int migratedAssetsCount = 0;
        this.updateDuplicatedBlobRef(assetBlobs);
        try {
            if (assetBlobStore.updateBlobRefs(assetBlobs)) {
                migratedAssetsCount = assetBlobs.size();
                this.log.info("Migrated {} {} to the new blob ref fields", (Object)format, (Object)migratedAssetsCount);
            } else {
                this.log.info("Could not migrate {} {} blobs with new blob ref fields", (Object)format, (Object)assetBlobs.size());
            }
        }
        catch (DuplicateKeyException e) {
            this.log.error("Error updating asset blobs in batch fashion. Error {}", (Object)e.getMessage());
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            migratedAssetsCount = this.migrateRowByRow(assetBlobStore, format, assetBlobs);
        }
        return migratedAssetsCount;
    }

    @VisibleForTesting
    void updateDuplicatedBlobRef(Collection<AssetBlob> assetBlobs) {
        assetBlobs.stream().collect(Collectors.groupingBy(AssetBlob::blobRef)).values().stream().filter(blobs -> blobs.size() > 1).flatMap(Collection::stream).filter(a -> a instanceof AssetBlobData).map(assetBlob -> (AssetBlobData)assetBlob).forEach(assetBlobData -> {
            BlobRef oldBlobRef = assetBlobData.blobRef();
            BlobRef newBlobRef = new BlobRef(oldBlobRef.getStore(), UUID.randomUUID().toString());
            assetBlobData.setBlobRef(newBlobRef);
        });
    }

    private int migrateRowByRow(AssetBlobStore<?> assetBlobStore, String format, Collection<AssetBlob> assetBlobs) {
        AtomicInteger updated = new AtomicInteger();
        assetBlobs.forEach(assetBlob -> {
            try {
                if (assetBlobStore.updateBlobRef((AssetBlob)assetBlob)) {
                    this.log.info("Asset blob {} {} updated with new blob ref format", (Object)format, assetBlob);
                    updated.getAndIncrement();
                } else {
                    this.log.info("Could not migrate {} {} blobs with new blob ref fields", (Object)format, assetBlob);
                }
            }
            catch (DuplicateKeyException duplicateKeyException) {
                this.log.error("Error migration {} {} asset blob to new blob ref format", (Object)format, assetBlob);
            }
        });
        return updated.get();
    }

    public String getMessage() {
        return this.getName();
    }
}

