/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Date;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.RepositoryStartedEvent;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.content.store.internal.AssetBlobCleanupTask;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.events.TaskDeletedEvent;
import org.sonatype.nexus.scheduling.schedule.Cron;
import org.sonatype.nexus.scheduling.schedule.Schedule;

@FeatureFlag(name="nexus.datastore.enabled")
@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Singleton
public class AssetBlobCleanupTaskManager
extends LifecycleSupport
implements EventAware,
EventAware.Asynchronous {
    private final TaskScheduler taskScheduler;
    private final SetMultimap<String, String> activeFormatStores = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());

    @Inject
    public AssetBlobCleanupTaskManager(TaskScheduler taskScheduler) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryStartedEvent event) {
        Configuration repositoryConfiguration;
        NestedAttributesMap storageAttributes;
        String contentStore;
        String format = event.getRepository().getFormat().getValue();
        if (this.activeFormatStores.put((Object)format, (Object)(contentStore = (String)(storageAttributes = (repositoryConfiguration = event.getRepository().getConfiguration()).attributes("storage")).get("dataStoreName", (Object)"nexus"))) && this.isStarted()) {
            this.scheduleAssetBlobCleanupTask(format, contentStore);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(TaskDeletedEvent event) {
        TaskInfo taskInfo = event.getTaskInfo();
        if ("assetBlob.cleanup".equals(taskInfo.getTypeId())) {
            TaskConfiguration taskConfiguration = taskInfo.getConfiguration();
            String format = taskConfiguration.getString("format");
            String contentStore = taskConfiguration.getString("contentStore");
            this.activeFormatStores.remove((Object)format, (Object)contentStore);
        }
    }

    protected void doStart() throws Exception {
        this.activeFormatStores.forEach(this::scheduleAssetBlobCleanupTask);
    }

    private void scheduleAssetBlobCleanupTask(String format, String contentStore) {
        ImmutableMap settings = ImmutableMap.of((Object)"format", (Object)format, (Object)"contentStore", (Object)contentStore);
        if (this.taskScheduler.getTaskByTypeId("assetBlob.cleanup", (Map)settings) == null) {
            TaskConfiguration taskConfiguration = this.taskScheduler.createTaskConfigurationInstance("assetBlob.cleanup");
            taskConfiguration.setName("Cleanup unused " + format + " blobs from " + contentStore);
            taskConfiguration.setString("format", format);
            taskConfiguration.setString("contentStore", contentStore);
            Cron schedule = this.taskScheduler.getScheduleFactory().cron(new Date(), AssetBlobCleanupTask.CRON_SCHEDULE);
            this.log.info("Scheduling cleanup of unused {} blobs from {}", (Object)format, (Object)contentStore);
            this.taskScheduler.scheduleTask(taskConfiguration, (Schedule)schedule);
        }
    }
}

