/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.logging.task.TaskLogType;
import org.sonatype.nexus.logging.task.TaskLogging;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.store.AssetBlobStore;
import org.sonatype.nexus.repository.content.store.BlobRefTypeHandler;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskSupport;
import org.sonatype.nexus.thread.NexusThreadFactory;

@Named
@TaskLogging(value=TaskLogType.NEXUS_LOG_ONLY)
public class AssetBlobCleanupTask
extends TaskSupport
implements Cancelable {
    static final String PROPERTY_PREFIX = "nexus.assetBlobCleanupTask.";
    static final String CRON_SCHEDULE = SystemPropertiesHelper.getString((String)"nexus.assetBlobCleanupTask.cronSchedule", (String)"0 */30 * * * ?");
    static final int BATCH_SIZE = SystemPropertiesHelper.getInteger((String)"nexus.assetBlobCleanupTask.batchSize", (int)100);
    static final boolean HARD_DELETE = SystemPropertiesHelper.getBoolean((String)"nexus.assetBlobCleanupTask.hardDelete", (boolean)false);
    static final int BLOB_CREATED_DELAY_MINUTE = SystemPropertiesHelper.getInteger((String)"nexus.assetBlobCleanupTask.blobCreatedDelayMinute", (int)60);
    static final int BATCH_DELETE_POOL_SIZE = SystemPropertiesHelper.getInteger((String)"nexus.assetBlobCleanupTask.batchDeleteThreadPoolSize", (int)8);
    private final Map<String, FormatStoreManager> formatStoreManagers;
    private final BlobStoreManager blobStoreManager;
    private Boolean batchDeleteEnabled = true;
    private ExecutorService batchDeleteExecutorService;

    @Inject
    public AssetBlobCleanupTask(Map<String, FormatStoreManager> formatStoreManagers, BlobStoreManager blobStoreManager) {
        this.formatStoreManagers = (Map)Preconditions.checkNotNull(formatStoreManagers);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
    }

    protected void initBatchDeleteIfEnabled(String format) {
        String batchDeleteIgnoreFormats = SystemPropertiesHelper.getString((String)"nexus.assetBlobCleanupTask.batchDeleteIgnoreForFormat", null);
        if (batchDeleteIgnoreFormats != null && format != null && batchDeleteIgnoreFormats.contains(format)) {
            this.batchDeleteEnabled = false;
        } else {
            this.batchDeleteExecutorService = Executors.newFixedThreadPool(BATCH_DELETE_POOL_SIZE, (ThreadFactory)new NexusThreadFactory("blobstore", "async-ops"));
        }
    }

    protected Void execute() throws Exception {
        String format = this.getConfiguration().getString("format");
        String contentStore = this.getConfiguration().getString("contentStore");
        this.initBatchDeleteIfEnabled(format);
        FormatStoreManager formatStoreManager = this.formatStoreManagers.get(format);
        if (formatStoreManager != null) {
            int deleteCount;
            this.log.debug("Checking for unused {} blobs from {}", (Object)format, (Object)contentStore);
            Object assetBlobStore = formatStoreManager.assetBlobStore(contentStore);
            if (this.batchDeleteEnabled.booleanValue()) {
                try {
                    deleteCount = this.deleteUnusedAssetBlobsBatch((AssetBlobStore<?>)((Object)assetBlobStore), format, contentStore);
                }
                finally {
                    if (!this.batchDeleteExecutorService.isShutdown()) {
                        this.batchDeleteExecutorService.shutdown();
                    }
                }
            } else {
                deleteCount = this.deleteUnusedAssetBlobs((AssetBlobStore<?>)((Object)assetBlobStore), format, contentStore);
            }
            if (deleteCount > 0) {
                this.log.info("Deleted {} unused {} blobs from {}", new Object[]{deleteCount, format, contentStore});
            }
        } else {
            this.log.warn("Unknown format {}", (Object)format);
        }
        return null;
    }

    @Deprecated
    private int deleteUnusedAssetBlobs(AssetBlobStore<?> assetBlobStore, String format, String contentStore) {
        int deleteCount = 0;
        Continuation<AssetBlob> unusedAssetBlobs = assetBlobStore.browseUnusedAssetBlobs(BATCH_SIZE, BLOB_CREATED_DELAY_MINUTE, null);
        while (!this.isCanceled() && !unusedAssetBlobs.isEmpty()) {
            this.log.debug("Found {} unused {} blobs in {}", new Object[]{unusedAssetBlobs.size(), format, contentStore});
            for (AssetBlob assetBlob : unusedAssetBlobs) {
                if (this.isCanceled()) break;
                try {
                    if (this.deleteAssetBlob(assetBlobStore, assetBlob.blobRef())) {
                        ++deleteCount;
                        continue;
                    }
                    this.log.debug("Could not delete {} blob {} from {}", new Object[]{format, assetBlob.blobRef(), contentStore});
                }
                catch (RuntimeException e) {
                    this.log.debug("Could not delete {} blob {} from {}", new Object[]{format, assetBlob.blobRef(), contentStore, e});
                }
            }
            unusedAssetBlobs = assetBlobStore.browseUnusedAssetBlobs(BATCH_SIZE, BLOB_CREATED_DELAY_MINUTE, unusedAssetBlobs.nextContinuationToken());
        }
        return deleteCount;
    }

    @VisibleForTesting
    int deleteUnusedAssetBlobsBatch(AssetBlobStore<?> assetBlobStore, String format, String contentStore) {
        int deleteCount = 0;
        Continuation<AssetBlob> unusedAssetBlobs = assetBlobStore.browseUnusedAssetBlobs(BATCH_SIZE, BLOB_CREATED_DELAY_MINUTE, null);
        while (!this.isCanceled() && !unusedAssetBlobs.isEmpty()) {
            if (this.isCanceled()) break;
            this.log.debug("Found {} unused {} blobs in {}", new Object[]{unusedAssetBlobs.size(), format, contentStore});
            List<BlobRef> blobRefAll = this.extractBlobRefsFromAssetBlobs(unusedAssetBlobs);
            this.deleteAssetBlobsExecutorService(blobRefAll);
            String[] blobRefIds = (String[])blobRefAll.stream().map(BlobRefTypeHandler::toPersistableString).toArray(String[]::new);
            assetBlobStore.deleteAssetBlobBatch(blobRefIds);
            deleteCount += blobRefAll.size();
            unusedAssetBlobs = assetBlobStore.browseUnusedAssetBlobs(BATCH_SIZE, BLOB_CREATED_DELAY_MINUTE, unusedAssetBlobs.nextContinuationToken());
        }
        return deleteCount;
    }

    private boolean deleteAssetBlob(AssetBlobStore<?> assetBlobStore, BlobRef blobRef) {
        boolean assetBlobDeleted = false;
        BlobStore blobStore = this.blobStoreManager.get(blobRef.getStore());
        if (blobStore == null) {
            this.log.warn("Could not find blob store for {}", (Object)blobRef);
        } else {
            assetBlobDeleted = assetBlobStore.deleteAssetBlob(blobRef);
            if (assetBlobDeleted && !this.deleteBlobContent(blobStore, blobRef)) {
                this.log.warn("Could not delete blob content under {}", (Object)blobRef);
            }
        }
        return assetBlobDeleted;
    }

    private void deleteAssetBlobsExecutorService(List<BlobRef> blobRefs) {
        CountDownLatch latch = new CountDownLatch(blobRefs.size());
        for (BlobRef blobRef : blobRefs) {
            this.batchDeleteExecutorService.submit(() -> {
                latch.countDown();
                BlobStore blobStore = this.blobStoreManager.get(blobRef.getStore());
                if (blobStore == null) {
                    this.log.warn("Could not find blob store for {}", (Object)blobRef);
                } else if (!this.deleteBlobContent(blobStore, blobRef)) {
                    this.log.warn("Could not delete blob content under {}", (Object)blobRef);
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            this.log.debug("CountDownLatch interrupted", (Throwable)ex);
        }
    }

    private boolean deleteBlobContent(BlobStore blobStore, BlobRef blobRef) {
        if (HARD_DELETE) {
            return blobStore.deleteHard(blobRef.getBlobId());
        }
        return blobStore.delete(blobRef.getBlobId(), "Removing unused asset blob");
    }

    private List<BlobRef> extractBlobRefsFromAssetBlobs(Continuation<AssetBlob> assetBlobs) {
        return assetBlobs.stream().map(AssetBlob::blobRef).filter(blobRef -> this.blobStoreManager.get(blobRef.getStore()) != null).collect(Collectors.toList());
    }

    public String getMessage() {
        return this.getName();
    }

    public void cancel() {
        super.cancel();
        if (this.batchDeleteExecutorService != null) {
            this.batchDeleteExecutorService.shutdown();
        }
    }
}

