/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store.internal;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.event.asset.AssetAttributesEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetCreatedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetDeletedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetDownloadedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetKindEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetPurgedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetUpdatedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetUploadedEvent;

@Named
@Singleton
public class AssetAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "repository.asset";
    private final boolean attributeChangesDetailEnabled;

    @Inject
    public AssetAuditor(@Named(value="${nexus.audit.attribute.changes.enabled:-true}") @Named(value="${nexus.audit.attribute.changes.enabled:-true}") boolean attributeChangesDetailEnabled) {
        this.registerType(AssetCreatedEvent.class, "created");
        this.registerType(AssetDeletedEvent.class, "deleted");
        this.registerType(AssetPurgedEvent.class, "purged");
        this.registerType(AssetUpdatedEvent.class, "updated");
        this.registerType(AssetAttributesEvent.class, "updated-attribute");
        this.registerType(AssetDownloadedEvent.class, "updated-downloaded");
        this.registerType(AssetKindEvent.class, "updated-kind");
        this.registerType(AssetUploadedEvent.class, "updated-uploaded");
        this.attributeChangesDetailEnabled = attributeChangesDetailEnabled;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(AssetPurgedEvent event) {
        if (this.isRecording()) {
            String repositoryName = event.getRepository().map(Repository::getName).orElse("Unknown");
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType(this.type(event.getClass()));
            data.setContext(repositoryName);
            Map attributes = data.getAttributes();
            attributes.put("repository.name", repositoryName);
            attributes.put("assetIds", Arrays.toString(event.getAssetIds()));
            this.record(data);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(AssetEvent event) {
        if (this.isRecording()) {
            Asset asset = event.getAsset();
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType(this.type(event.getClass()));
            data.setContext(asset.path());
            Map attributes = data.getAttributes();
            attributes.put("repository.name", event.getRepository().map(Repository::getName).orElse("Unknown"));
            attributes.put("path", asset.path());
            attributes.put("kind", asset.kind());
            if (event instanceof AssetAttributesEvent && this.attributeChangesDetailEnabled) {
                AssetAttributesEvent attributesEvent = (AssetAttributesEvent)event;
                attributes.put("attribute.changes", attributesEvent.getChanges().stream().map(change -> {
                    HashMap<String, Object> entry = new HashMap<String, Object>();
                    entry.put("operation", (Object)change.getOperation());
                    entry.put("key", change.getKey());
                    entry.put("value", change.getValue());
                    return entry;
                }).collect(Collectors.toList()));
            }
            this.record(data);
        }
    }
}

