/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.app.FeatureFlagGroup;
import org.sonatype.nexus.common.db.DatabaseCheck;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.store.ContentRepositoryStore;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.manager.RepositoryCreatedEvent;
import org.sonatype.nexus.repository.manager.RepositoryDeletedEvent;

@Named
@Singleton
@FeatureFlagGroup(value={@FeatureFlag(name="nexus.datastore.enabled"), @FeatureFlag(name="nexus.repository.size", enabledByDefault=true)})
public class RepositoryNameIdMappingCache
extends ComponentSupport
implements EventAware {
    private volatile Map<String, Integer> nameRepositoryIdMap;
    private final ContentRepositoryStore<?> contentRepositoryStore;
    private final List<String> formatNames;
    private boolean isAvailable;

    @Inject
    public RepositoryNameIdMappingCache(FormatStoreManager formatStoreManager, List<Format> formats, DatabaseCheck databaseCheck) {
        this.contentRepositoryStore = ((FormatStoreManager)Preconditions.checkNotNull((Object)formatStoreManager)).contentRepositoryStore("nexus");
        this.formatNames = ((List)Preconditions.checkNotNull(formats)).stream().map(Format::getValue).collect(Collectors.toList());
        this.isAvailable = ((DatabaseCheck)Preconditions.checkNotNull((Object)databaseCheck)).isPostgresql();
    }

    @Subscribe
    public void on(RepositoryCreatedEvent event) {
        if (!this.isAvailable) {
            return;
        }
        Repository repository = event.getRepository();
        this.log.debug("Handling repository create event for {}", (Object)repository.getName());
        this.fetchRepositoryId(repository.getName(), repository.getFormat().getValue());
    }

    @Subscribe
    public void on(RepositoryDeletedEvent event) {
        if (!this.isAvailable) {
            return;
        }
        this.log.debug("Handling repository deleted event for {}", (Object)event.getRepository().getName());
        if (this.nameRepositoryIdMap != null) {
            this.nameRepositoryIdMap.remove(event.getRepository().getName());
        }
    }

    public Map<Integer, String> getRepositoryNameIds(List<String> repositoryNames, String format) {
        return repositoryNames.stream().map(name -> new AbstractMap.SimpleEntry<OptionalInt, String>(this.fetchRepositoryId((String)name, format), (String)name)).filter(entry -> ((OptionalInt)entry.getKey()).isPresent()).collect(Collectors.toMap(entry -> ((OptionalInt)entry.getKey()).getAsInt(), AbstractMap.SimpleEntry::getValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Integer> getCache() {
        Map<String, Integer> cache = this.nameRepositoryIdMap;
        if (cache == null) {
            RepositoryNameIdMappingCache repositoryNameIdMappingCache = this;
            synchronized (repositoryNameIdMappingCache) {
                if (this.nameRepositoryIdMap == null) {
                    this.nameRepositoryIdMap = this.populateCache();
                }
                cache = this.nameRepositoryIdMap;
            }
        }
        return cache;
    }

    private OptionalInt fetchRepositoryId(String name, String format) {
        if (this.getCache().containsKey(name)) {
            return OptionalInt.of(this.getCache().get(name));
        }
        Optional<Map<String, Object>> repositoryNameId = this.contentRepositoryStore.readContentRepositoryId(format, name);
        if (repositoryNameId.isPresent() && repositoryNameId.get().containsValue(name)) {
            int repositoryId = (Integer)repositoryNameId.get().get("repository_id");
            this.nameRepositoryIdMap.put(name, repositoryId);
            return OptionalInt.of(repositoryId);
        }
        return OptionalInt.empty();
    }

    private Map<String, Integer> populateCache() {
        ConcurrentHashMap<String, Integer> cache = new ConcurrentHashMap<String, Integer>();
        List<Map<String, Object>> ids = this.contentRepositoryStore.readAllContentRepositoryIds(this.formatNames);
        ids.stream().forEach(id -> {
            Integer n = cache.put((String)id.get("name"), (Integer)id.get("repository_id"));
        });
        return cache;
    }
}

