/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.sonatype.nexus.datastore.api.ContentDataAccess;
import org.sonatype.nexus.repository.content.store.AssetBlobDAO;
import org.sonatype.nexus.repository.content.store.AssetBlobStore;
import org.sonatype.nexus.repository.content.store.AssetDAO;
import org.sonatype.nexus.repository.content.store.AssetStore;
import org.sonatype.nexus.repository.content.store.ComponentDAO;
import org.sonatype.nexus.repository.content.store.ComponentStore;
import org.sonatype.nexus.repository.content.store.ContentRepositoryDAO;
import org.sonatype.nexus.repository.content.store.ContentRepositoryStore;
import org.sonatype.nexus.repository.content.store.ContentStoreSupport;
import org.sonatype.nexus.repository.content.store.FormatStoreFactory;

public class FormatStoreManager {
    private final Cache<String, ContentStoreSupport<?>> cachedStores = CacheBuilder.newBuilder().weakValues().build();
    private final String formatClassPrefix;
    private Map<String, FormatStoreFactory> formatStoreFactories;

    FormatStoreManager(String formatClassPrefix) {
        this.formatClassPrefix = (String)Preconditions.checkNotNull((Object)formatClassPrefix);
    }

    @Inject
    void setFormatStoreFactories(Map<String, FormatStoreFactory> formatStoreFactories) {
        this.formatStoreFactories = (Map)Preconditions.checkNotNull(formatStoreFactories);
    }

    public <T extends ContentRepositoryStore<?>> T contentRepositoryStore(String contentStoreName) {
        return (T)((Object)((ContentRepositoryStore)((Object)this.formatStore(contentStoreName, ContentRepositoryDAO.class))));
    }

    public <T extends ComponentStore<?>> T componentStore(String contentStoreName) {
        return (T)((Object)((ComponentStore)((Object)this.formatStore(contentStoreName, ComponentDAO.class))));
    }

    public <T extends AssetStore<?>> T assetStore(String contentStoreName) {
        return (T)((Object)((AssetStore)((Object)this.formatStore(contentStoreName, AssetDAO.class))));
    }

    public <T extends AssetBlobStore<?>> T assetBlobStore(String contentStoreName) {
        return (T)((Object)((AssetBlobStore)((Object)this.formatStore(contentStoreName, AssetBlobDAO.class))));
    }

    public <T extends ContentStoreSupport<D>, D extends ContentDataAccess> T formatStore(String contentStoreName, Class<? extends D> daoClass) {
        String cacheKey = String.valueOf(contentStoreName) + '/' + this.formatDaoName(daoClass);
        try {
            return (T)((Object)((ContentStoreSupport)((Object)this.cachedStores.get((Object)cacheKey, () -> this.createFormatStore(contentStoreName, daoClass)))));
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException(e.getCause());
        }
    }

    private ContentStoreSupport<?> createFormatStore(String contentStoreName, Class<?> daoClass) {
        FormatStoreFactory factory = this.formatStoreFactories.get(this.formatDaoName(daoClass));
        if (factory != null) {
            return factory.createFormatStore(contentStoreName);
        }
        throw new IllegalArgumentException("Unexpected DAO class: " + daoClass);
    }

    private String formatDaoName(Class<?> daoClass) {
        String daoName = daoClass.getSimpleName();
        if (daoName.startsWith(this.formatClassPrefix)) {
            return daoName;
        }
        return String.valueOf(this.formatClassPrefix) + daoName;
    }
}

