/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store;

import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.eclipse.sisu.inject.TypeArguments;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.datastore.TransactionalStoreSupport;
import org.sonatype.nexus.datastore.api.ContentDataAccess;
import org.sonatype.nexus.datastore.api.DataSession;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.datastore.api.DuplicateKeyException;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.transaction.Transaction;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

public abstract class ContentStoreSupport<T extends ContentDataAccess>
extends TransactionalStoreSupport {
    private static final int DELETE_BATCH_SIZE_DEFAULT = SystemPropertiesHelper.getInteger((String)"nexus.content.deleteBatchSize", (int)1000);
    private final Class<T> daoClass;

    protected ContentStoreSupport(DataSessionSupplier sessionSupplier, String contentStoreName) {
        super(sessionSupplier, contentStoreName);
        TypeLiteral superType = TypeLiteral.get(((Object)((Object)this)).getClass()).getSupertype(ContentStoreSupport.class);
        this.daoClass = TypeArguments.get((TypeLiteral)superType, (int)0).getRawType();
    }

    protected ContentStoreSupport(DataSessionSupplier sessionSupplier, String contentStoreName, Class<T> daoClass) {
        super(sessionSupplier, contentStoreName);
        this.daoClass = (Class)Preconditions.checkNotNull(daoClass);
    }

    protected DataSession<?> thisSession() {
        return (DataSession)UnitOfWork.currentSession();
    }

    protected T dao() {
        return (T)((ContentDataAccess)this.thisSession().access(this.daoClass));
    }

    protected void commitChangesSoFar() {
        Transaction tx = UnitOfWork.currentTx();
        tx.commit();
        tx.begin();
        CancelableHelper.checkCancellation();
    }

    protected int deleteBatchSize() {
        return DELETE_BATCH_SIZE_DEFAULT;
    }

    @Transactional(retryOn={DuplicateKeyException.class})
    public <D> D getOrCreate(Supplier<Optional<D>> find, Supplier<D> create) {
        return find.get().orElseGet(create);
    }

    public <D> D save(Supplier<Optional<D>> find, Supplier<D> create, UnaryOperator<D> update, Consumer<D> postTransaction) {
        D result = this.transactionalSave(find, create, update);
        postTransaction.accept(result);
        return result;
    }

    @Transactional(retryOn={DuplicateKeyException.class})
    protected <D> D transactionalSave(Supplier<Optional<D>> find, Supplier<D> create, UnaryOperator<D> update) {
        return (D)find.get().map(update).orElseGet(create);
    }
}

