/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.sonatype.nexus.common.event.Event;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.datastore.api.ContentDataAccess;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.datastore.api.SchemaTemplate;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.facet.ContentFacetFinder;
import org.sonatype.nexus.repository.content.store.ContentStoreEvent;
import org.sonatype.nexus.repository.content.store.ContentStoreSupport;

public abstract class ContentStoreEventSupport<T extends ContentDataAccess>
extends ContentStoreSupport<T> {
    protected final String format;
    protected EventManager eventManager;
    private ContentFacetFinder contentFacetFinder;

    protected ContentStoreEventSupport(DataSessionSupplier sessionSupplier, String contentStoreName, Class<T> daoClass) {
        super(sessionSupplier, contentStoreName, daoClass);
        this.format = this.extractFormat(daoClass);
    }

    @Inject
    protected void setDependencies(ContentFacetFinder contentFacetFinder, EventManager eventManager) {
        this.contentFacetFinder = (ContentFacetFinder)((Object)Preconditions.checkNotNull((Object)((Object)contentFacetFinder)));
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    public void preCommitEvent(Supplier<Event> eventSupplier) {
        this.thisSession().preCommit(() -> this.postEvent(eventSupplier));
    }

    public void postCommitEvent(Supplier<Event> eventSupplier) {
        this.thisSession().postCommit(() -> this.postEvent(eventSupplier));
    }

    private void postEvent(Supplier<Event> eventSupplier) {
        Event event = eventSupplier.get();
        if (event instanceof ContentStoreEvent) {
            ContentStoreEvent cse = (ContentStoreEvent)event;
            cse.setRepositorySupplier(this.repositorySupplierFor(cse));
        }
        this.eventManager.post((Object)event);
    }

    private Supplier<Optional<Repository>> repositorySupplierFor(ContentStoreEvent event) {
        return () -> this.contentFacetFinder.findRepository(this.format, contentStoreEvent.contentRepositoryId);
    }

    private String extractFormat(Class<T> daoClass) {
        String formatDao = daoClass.getSimpleName();
        String dao = Arrays.stream(daoClass.getInterfaces()).filter(c -> c.isAnnotationPresent(SchemaTemplate.class)).map(Class::getSimpleName).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot determine format"));
        String prefix = Strings2.lower((String)formatDao.substring(0, formatDao.length() - dao.length()));
        Preconditions.checkArgument((!prefix.isEmpty() ? 1 : 0) != 0, (String)"%s must add a prefix to %s", (Object)formatDao, (Object)dao);
        return prefix;
    }
}

