/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.event.Event;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;

public class ContentStoreEvent
implements Event {
    final int contentRepositoryId;
    private Supplier<Optional<Repository>> repositorySupplier;

    protected ContentStoreEvent(int contentRepositoryId) {
        this.contentRepositoryId = contentRepositoryId;
    }

    @Nullable
    public String getFormat() {
        return this.getRepository().map(Repository::getFormat).map(Format::getValue).orElse(null);
    }

    public Optional<Repository> getRepository() {
        Preconditions.checkState((this.repositorySupplier != null ? 1 : 0) != 0, (Object)"Repository supplier has not been set");
        return this.repositorySupplier.get();
    }

    void setRepositorySupplier(Supplier<Optional<Repository>> repositorySupplier) {
        Preconditions.checkState((this.repositorySupplier == null ? 1 : 0) != 0, (Object)"Repository supplier is already set");
        this.repositorySupplier = (Supplier)Preconditions.checkNotNull(repositorySupplier);
    }

    public String toString() {
        Optional<Repository> repository = this.repositorySupplier == null ? null : this.repositorySupplier.get();
        return "ContentStoreEvent{contentRepositoryId=" + this.contentRepositoryId + ", repository=" + repository + '}';
    }
}

